/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;

public class EnumStringConverter<T extends Enum<T>>
implements Converter<Enum<?>, String> {
    private Class<T> enumType;

    public EnumStringConverter(Class<T> enumType) {
        this.enumType = enumType;
    }

    @Override
    public String convert(Enum<?> enumValue) {
        if (enumValue == null) {
            return null;
        }
        return enumValue.toString().toLowerCase();
    }

    @Override
    public Enum<?> reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable to convert from String to Enum<" + this.enumType.getSimpleName() + ">: stringValue was null");
        }
        try {
            return Enum.valueOf(this.enumType, stringValue.toUpperCase());
        }
        catch (Exception e) {
            throw new ConversionException("Unable to convert from String to Enum<" + this.enumType.getSimpleName() + ">. Original message: " + e.getMessage(), e.getCause());
        }
    }
}

