/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.lang.reflect.Field;

public class ColorStringConverter
implements Converter<Paint, String> {
    static ESLLogger logger = ESLLogger.getLogger(ColorStringConverter.class);
    private static final String DELIMITER = ";";
    private static final int NUM_PARAMS_IN_STRING_REPRESENTATION = 4;
    private static final int GRADIENT_NUM_PARAMS_IN_STRING_REPRESENTATION = 12;
    private static final String TRANSPARENT_COLOR_KEY = "transparent";
    private static final Color TRANSPARENT_COLOR = new Color(255, 255, 255, 0);

    @Override
    public String convert(Paint colorValue) {
        Field[] colorFields;
        if (colorValue == null) {
            return null;
        }
        if (colorValue.equals(TRANSPARENT_COLOR)) {
            return TRANSPARENT_COLOR_KEY;
        }
        for (Field colorField : colorFields = Color.class.getFields()) {
            try {
                Color color;
                Object colorObject = colorField.get(null);
                if (!(colorObject instanceof Color) || !(color = (Color)colorObject).equals(colorValue)) continue;
                return colorField.getName();
            }
            catch (IllegalArgumentException exc) {
                logger.warn("Unable to convert from Color to String: %s", exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (IllegalAccessException exc) {
                logger.warn("Unable to convert from Color to String: %s", exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
        if (colorValue instanceof Color) {
            Color color = (Color)colorValue;
            return this.colorToString(color);
        }
        if (colorValue instanceof GradientPaint) {
            GradientPaint gradient = (GradientPaint)colorValue;
            return String.format("%d%s%d%s%s%s%d%s%d%s%s", (int)gradient.getPoint1().getX(), DELIMITER, (int)gradient.getPoint1().getY(), DELIMITER, this.colorToString(gradient.getColor1()), DELIMITER, (int)gradient.getPoint2().getX(), DELIMITER, (int)gradient.getPoint2().getY(), DELIMITER, this.colorToString(gradient.getColor2()));
        }
        return null;
    }

    private String colorToString(Color color) {
        return color.getRed() + DELIMITER + color.getGreen() + DELIMITER + color.getBlue() + DELIMITER + color.getAlpha();
    }

    @Override
    public Paint reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable to convert from String to Color: stringValue was null");
        }
        String[] splitValue = stringValue.split(DELIMITER);
        if (splitValue != null && splitValue.length == 4) {
            try {
                int r = Integer.parseInt(splitValue[0]);
                int g = Integer.parseInt(splitValue[1]);
                int b = Integer.parseInt(splitValue[2]);
                int a = Integer.parseInt(splitValue[3]);
                Color color = new Color(r, g, b, a);
                return color;
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to convert from String to Color.", e.getCause());
            }
        }
        if (splitValue != null && splitValue.length == 12) {
            try {
                int x1 = Integer.parseInt(splitValue[0]);
                int y1 = Integer.parseInt(splitValue[1]);
                int r1 = Integer.parseInt(splitValue[2]);
                int g1 = Integer.parseInt(splitValue[3]);
                int b1 = Integer.parseInt(splitValue[4]);
                int a1 = Integer.parseInt(splitValue[5]);
                int x2 = Integer.parseInt(splitValue[6]);
                int y2 = Integer.parseInt(splitValue[7]);
                int r2 = Integer.parseInt(splitValue[8]);
                int g2 = Integer.parseInt(splitValue[9]);
                int b2 = Integer.parseInt(splitValue[10]);
                int a2 = Integer.parseInt(splitValue[11]);
                Color color1 = new Color(r1, g1, b1, a1);
                Color color2 = new Color(r2, g2, b2, a2);
                return new GradientPaint(x1, y1, color1, x2, y2, color2);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Unable to convert from String to Color.", e.getCause());
            }
        }
        if (stringValue.toLowerCase().equals(TRANSPARENT_COLOR_KEY)) {
            return TRANSPARENT_COLOR;
        }
        try {
            Field colorField = Color.class.getField(stringValue.toUpperCase());
            Object colorObject = colorField.get(null);
            if (colorObject instanceof Color) {
                Color color = (Color)colorObject;
                return color;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        catch (SecurityException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        catch (NoSuchFieldException e) {
            throw new ConversionException("Unable to convert from String to Color.", e.getCause());
        }
        throw new ConversionException("Unable to convert from String to Color: stringValue can't be interpreted.");
    }
}

