/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options;

import at.mrdevelopment.toolkit.options.ArrayOption;
import at.mrdevelopment.toolkit.options.BooleanOption;
import at.mrdevelopment.toolkit.options.ColorOption;
import at.mrdevelopment.toolkit.options.DoubleOption;
import at.mrdevelopment.toolkit.options.EnumOption;
import at.mrdevelopment.toolkit.options.FontOption;
import at.mrdevelopment.toolkit.options.IntegerOption;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionContainer;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.StringOption;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionContainerImpl
implements OptionContainer {
    private Map<String, Option<?>> options = new HashMap();
    private Map<Option.Source, Integer> priorities = new HashMap<Option.Source, Integer>();

    @Override
    public void replaceOption(Option<?> option) throws OptionException {
        if (!this.options.containsKey(option.getKey())) {
            throw new OptionException(String.format("Option with key %s is not in option container.", option.getKey()));
        }
        this.options.put(option.getKey(), option);
    }

    @Override
    public void setOption(String key, int value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof IntegerOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((IntegerOption)option).set(value);
    }

    @Override
    public void setOption(String key, double value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof DoubleOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((DoubleOption)option).set(value);
    }

    @Override
    public void setOption(String key, String value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof StringOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((StringOption)option).set(value);
    }

    @Override
    public void setOption(String key, boolean value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof BooleanOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((BooleanOption)option).set(value);
    }

    @Override
    public void setOption(String key, Enum<?> value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof EnumOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((EnumOption)option).set(value);
    }

    @Override
    public void setOption(String key, Font value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof FontOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((FontOption)option).set(value);
    }

    @Override
    public void setOption(String key, Integer[] value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof ArrayOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((ArrayOption)option).set(value);
    }

    @Override
    public void setOption(String key, Color value) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option unavailable: " + key);
        }
        Option<?> option = this.options.get(key);
        if (!(option instanceof ColorOption)) {
            throw new OptionException("Option " + key + " is of different type: " + option.getClass().getSimpleName());
        }
        ((ColorOption)option).set(value);
    }

    public void setPriorities(Option.Source ... priorities) {
        int priority = priorities.length;
        for (Option.Source source : priorities) {
            if (this.priorities.containsKey((Object)source)) continue;
            this.priorities.put(source, priority);
            --priority;
        }
    }

    public int getPriority(Option.Source source) {
        if (this.priorities.containsKey((Object)source)) {
            return this.priorities.get((Object)source);
        }
        return 0;
    }

    public int comparePriorities(Option.Source source1, Option.Source source2) {
        int prio2;
        int prio1 = this.getPriority(source1);
        if (prio1 > (prio2 = this.getPriority(source2))) {
            return 1;
        }
        if (prio1 == prio2) {
            return 0;
        }
        return -1;
    }

    @Override
    public void inherit(OptionContainer container) throws OptionException {
        this.inherit(container.getOptions());
    }

    @Override
    public void inherit(List<Option<?>> incomingOptions) throws OptionException {
        for (Option<?> incomingOption : incomingOptions) {
            if (!this.options.containsKey(incomingOption.getKey())) continue;
            Option<?> localOption = this.options.get(incomingOption.getKey());
            if (this.comparePriorities(incomingOption.getSource(), localOption.getSource()) != 1) continue;
            localOption.setFromObject(incomingOption.getAsObject());
            localOption.setSource(Option.Source.SYSTEM);
        }
    }

    @Override
    public boolean matchingOptions(OptionContainer container) throws OptionException {
        return this.matchingOptions(container.getOptions());
    }

    @Override
    public boolean matchingOptions(List<Option<?>> incomingOptions) throws OptionException {
        if (incomingOptions.size() != this.options.size()) {
            return false;
        }
        for (Option<?> incomingOption : incomingOptions) {
            if (!this.options.containsKey(incomingOption.getKey())) {
                return false;
            }
            Option<?> localOption = this.options.get(incomingOption.getKey());
            if (incomingOption.get().equals(localOption.get())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Option<?> getOption(String key) throws OptionException {
        if (!this.options.containsKey(key)) {
            throw new OptionException("Option does not exist: " + key);
        }
        return this.options.get(key);
    }

    @Override
    public boolean hasOption(String key) {
        return this.options.containsKey(key);
    }

    @Override
    public List<Option<?>> getOptions() {
        ArrayList optionList = new ArrayList();
        optionList.addAll(this.options.values());
        return optionList;
    }

    @Override
    public double getDoubleOptionValue(String key) throws OptionException {
        try {
            return (Double)this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Double, Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public boolean getBooleanOptionValue(String key) throws OptionException {
        try {
            return (Boolean)this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Boolean, Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public String getStringOptionValue(String key) throws OptionException {
        try {
            return (String)this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: String, Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public int getIntegerOptionValue(String key) throws OptionException {
        try {
            return (Integer)this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Integer, Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public Enum<?> getEnumOptionValue(String key) throws OptionException {
        try {
            return (Enum)this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Enum<?>, Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public Font getFontOptionValue(String key) throws OptionException {
        try {
            return (Font)this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Font, Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public Paint getColorOptionValue(String key) throws OptionException {
        try {
            return (Paint)this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Color/GradientPaint, Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public Object[] getIntegerArrayOptionValue(String key) throws OptionException {
        try {
            return (Object[])this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Integer[], Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public Object[] getDoubleArrayOptionValue(String key) throws OptionException {
        try {
            return (Object[])this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: Double[], Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    @Override
    public Object[] getStringArrayOptionValue(String key) throws OptionException {
        try {
            return (Object[])this.getOption(key).get();
        }
        catch (ClassCastException e) {
            throw new OptionException("Invalid option type. Expected: String[], Actual: " + this.getOption(key).getValueClass().getSimpleName());
        }
    }

    public void registerOption(Option<?> option) {
        if (this.options.containsKey(option.getKey())) {
            System.err.println("Warning: duplicate usage of key. " + option);
        }
        this.options.put(option.getKey(), option);
    }

    public void unregisterOption(Option<?> option) {
        this.options.remove(option.getKey());
    }

    public String toString() {
        return "OptionContainerImpl [options=" + this.options + ", priorities=" + this.priorities + "]";
    }
}

