/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ExtendedByteBuffer {
    private final ByteBuffer buffer;

    private ExtendedByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer internal() {
        return this.buffer;
    }

    public int getUnsignedByte() {
        return 0xFF & this.buffer.get();
    }

    public int getUnsignedByte(int position) {
        return 0xFF & this.buffer.get(position);
    }

    public int getUnsignedShort() {
        return 0xFFFF & this.buffer.getShort();
    }

    public int getUnsignedShort(int position) {
        return 0xFFFF & this.buffer.getShort(position);
    }

    public static ExtendedByteBuffer createFrom(byte[] backingArray) {
        ByteBuffer buffer = ByteBuffer.wrap(backingArray);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ExtendedByteBuffer(buffer);
    }
}

