/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.network;

public class HostnameUtils {
    private static final String ONE_ALPHA = "(.)*((\\p{Alpha})|[-]|[_])(.)*";
    private static final String HOST_IDENTIFIER = "((\\p{Alnum})([_]|[-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})";
    private static final String HOSTNAME_RULE = "(((\\p{Alnum})([_]|[-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([_]|[-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*";

    public static boolean isValidHostname(String hostname, boolean allowEmpty) {
        String[] splittedHostname;
        if (!allowEmpty) {
            if (hostname == null || hostname.isEmpty()) {
                return false;
            }
        } else if (hostname == null || hostname.isEmpty()) {
            return true;
        }
        for (String hostnamePart : splittedHostname = hostname.split("\\.")) {
            if (hostnamePart.length() <= 63) continue;
            return false;
        }
        if (hostname == null || hostname.length() > 255) {
            return false;
        }
        if (!hostname.matches(HOSTNAME_RULE) || !hostname.matches(ONE_ALPHA)) {
            return false;
        }
        if (hostname.length() > 255) {
            return false;
        }
        return hostname.matches(HOSTNAME_RULE) && hostname.matches(ONE_ALPHA);
    }
}

