/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.network;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class FallbackIPAddressCalculator {
    public static InetAddress calculateFromMAC(String macAddress) throws IllegalArgumentException, UnknownHostException {
        String[] splittedMAC = macAddress.split(":");
        if (splittedMAC.length != 6) {
            throw new IllegalArgumentException(String.format("Invalid MAC address: %s", macAddress));
        }
        long address = 1L;
        for (int index = 0; index < splittedMAC.length; ++index) {
            address += (long)index * Long.parseLong(splittedMAC[index], 16);
        }
        address = address % 65024L + 256L;
        address = 0xA9FE0000L | address;
        byte[] ipAddress = new byte[]{(byte)(address >> 24), (byte)((address & 0xFF0000L) >> 16), (byte)((address & 0xFF00L) >> 8), (byte)(address & 0xFFL)};
        return InetAddress.getByAddress(ipAddress);
    }
}

