/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.math;

import at.mrdevelopment.toolkit.math.MathUtils;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilsTest {
    private static final double DELTA = 1.0E-6;
    private static Random random = new Random();

    @Test
    public void testLimitTo() {
        Assert.assertEquals((double)10.0, (double)MathUtils.limitTo(10.0, 0.0, 10.0), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)MathUtils.limitTo(-5.0, 0.0, 10.0), (double)1.0E-6);
    }

    @Test
    public void testNormalize() {
        Assert.assertEquals((double)0.0, (double)MathUtils.normalize(20.0, 20.0, 100.0), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)MathUtils.normalize(50.0, -50.0, 50.0), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.5, (double)MathUtils.normalize(0.0, -50.0, 50.0), (double)Double.MIN_VALUE);
    }

    @Test
    public void testLimitAndNormalize() {
        Assert.assertEquals((double)0.0, (double)MathUtils.limitAndNormalize(5.0, 20.0, 100.0), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)MathUtils.limitAndNormalize(200.0, -50.0, 50.0), (double)Double.MIN_VALUE);
        for (int index = 0; index < 100000; ++index) {
            int value = random.nextInt();
            int maxValue = random.nextInt();
            int minValue = random.nextInt();
            double result = MathUtils.limitAndNormalize(value, minValue, maxValue);
            Assert.assertTrue((result >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((result <= 1.0 ? 1 : 0) != 0);
        }
    }
}

