/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class RemoteLoggingListener
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(RemoteLoggingListener.class);
    private volatile boolean shutdownRequested = false;
    private Socket socket;
    private FileAppender appender;
    private String pattern;
    private ObjectInputStream inputStream;
    private String path;
    private boolean fileNameIsApId = false;
    private List<Appender> appenders;
    private boolean running = false;
    private boolean started = false;

    public RemoteLoggingListener(Socket socket, String pattern, String path) throws IOException {
        this(socket, pattern, path, new ArrayList<Appender>());
    }

    public RemoteLoggingListener(Socket socket, String pattern, String path, List<Appender> appenders) throws IOException {
        this.socket = socket;
        this.pattern = pattern;
        this.path = path;
        this.appenders = appenders;
        this.inputStream = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        this.started = true;
        try {
            while (!this.shutdownRequested && this.inputStream != null && this.socket.isConnected()) {
                LoggingEvent event = (LoggingEvent)this.inputStream.readObject();
                if (this.appender == null || !this.fileNameIsApId) {
                    String fileName = (String)event.getMDC("AP_ID");
                    if (fileName == null) {
                        this.fileNameIsApId = false;
                        fileName = this.socket.getInetAddress().getHostName();
                    } else {
                        File oldLogFile = new File(this.path + this.socket.getInetAddress().getHostName() + ".log");
                        if (oldLogFile.exists()) {
                            String line;
                            FileInputStream fileInputStream = new FileInputStream(oldLogFile);
                            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                            BufferedReader reader = new BufferedReader(new InputStreamReader(dataInputStream));
                            StringBuilder oldLogs = new StringBuilder();
                            while ((line = reader.readLine()) != null) {
                                oldLogs.append(line);
                                oldLogs.append(System.getProperty("line.separator"));
                            }
                            dataInputStream.close();
                            File newLogFile = new File(this.path + fileName + ".log");
                            if (!newLogFile.exists()) {
                                newLogFile.createNewFile();
                            }
                            FileWriter outFile = new FileWriter(newLogFile, true);
                            PrintWriter outWriter = new PrintWriter(outFile);
                            outWriter.append(oldLogs.toString());
                            outWriter.close();
                            FileUtils.deleteQuietly((File)oldLogFile);
                        }
                        this.fileNameIsApId = true;
                    }
                    PatternLayout layout = new PatternLayout(this.pattern);
                    this.appender = new FileAppender((Layout)layout, this.path + fileName + ".log");
                }
                this.append(event);
            }
        }
        catch (Exception exc) {
            logger.warn("Could not receive logging event");
            logger.logExceptionIfDebugEnabled(exc);
        }
        finally {
            this.cleanup();
        }
    }

    private synchronized void cleanup() {
        this.running = false;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException exc) {
                logger.logExceptionIfDebugEnabled(exc);
                logger.warn("Error closing inputstream");
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException exc) {
                logger.logExceptionIfDebugEnabled(exc);
                logger.warn("Error closing socket");
            }
        }
    }

    private void append(LoggingEvent event) {
        if (this.appender != null) {
            this.appender.append(event);
        }
        if (this.appenders != null) {
            for (Appender otherAppender : this.appenders) {
                otherAppender.doAppend(event);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdownRequested = true;
        this.cleanup();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isStarted() {
        return this.started;
    }
}

