/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.ShutdownableShutdownHook;
import at.mrdevelopment.toolkit.log.RemoteLogServer;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;

public class RemoteLogger {
    private static final int DEFAULT_LOGGING_PORT = 5005;
    private static final String DEFAULT_PATTERN = "[%d][%t][%X{ADDRESS}][%X{application}][%p %c{1}]: %m%n";
    private static final String DEFAULT_LOG_FILE_PATH = "";
    private final RemoteLogServer remoteLogServer;
    private List<Appender> appenders;

    public static void main(String[] args) {
        try {
            new RemoteLogger(args);
        }
        catch (InitializationException exc) {
            exc.printStackTrace();
            System.exit(1);
        }
    }

    public RemoteLogger(String[] arguments, OutputStream outputStream) throws InitializationException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionPort = parser.accepts("port", "Port").withOptionalArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionPattern = parser.accepts("pattern", "Logging Layout Pattern").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec optionPath = parser.accepts("path", "Path for log files").withOptionalArg().ofType(String.class);
        OptionSet options = parser.parse(arguments);
        int port = options.has((OptionSpec)optionPort) ? (Integer)options.valueOf((OptionSpec)optionPort) : 5005;
        String pattern = options.has((OptionSpec)optionPattern) ? (String)options.valueOf((OptionSpec)optionPattern) : DEFAULT_PATTERN;
        String path = options.has((OptionSpec)optionPath) ? (String)options.valueOf((OptionSpec)optionPath) : DEFAULT_LOG_FILE_PATH;
        this.appenders = new ArrayList<Appender>();
        if (outputStream != null) {
            this.appenders.add((Appender)new WriterAppender((Layout)new PatternLayout(pattern), outputStream));
        }
        this.remoteLogServer = new RemoteLogServer(port, pattern, path, this.appenders);
        Runtime.getRuntime().addShutdownHook(new ShutdownableShutdownHook(new Shutdownable[]{this.remoteLogServer}));
        this.remoteLogServer.start();
    }

    public RemoteLogger(String[] arguments) throws InitializationException {
        this(arguments, null);
    }

    public void changeLogLevel(String logLevel) {
        Priority priority = Priority.toPriority((String)logLevel);
        for (Appender appender : this.appenders) {
            if (!(appender instanceof WriterAppender)) continue;
            WriterAppender writerAppender = (WriterAppender)appender;
            writerAppender.setThreshold(priority);
        }
    }

    public void shutdown() {
        this.remoteLogServer.shutdown();
    }
}

