/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.ShutdownableShutdownHook;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.log.RemoteLoggingListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;

public class RemoteLogServer
extends Thread
implements Shutdownable {
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    static ESLLogger logger = ESLLogger.getLogger(RemoteLogServer.class);
    private boolean shutdownRequested = false;
    private ServerSocket serverSocket;
    private Set<RemoteLoggingListener> listeners = new HashSet<RemoteLoggingListener>();
    private String pattern;
    private String path;
    private List<Appender> appenders;

    public RemoteLogServer(int port, String pattern, String path) throws InitializationException {
        this(port, pattern, path, new ArrayList<Appender>());
    }

    public RemoteLogServer(int port, String pattern, String path, List<Appender> appenders) throws InitializationException {
        this.pattern = pattern;
        this.path = path;
        this.appenders = appenders;
        try {
            this.serverSocket = new ServerSocket(port);
            this.serverSocket.setSoTimeout(30000);
        }
        catch (IOException exc) {
            throw new InitializationException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            if (this.shutdownRequested) {
                this.cleanup();
                return;
            }
            try {
                Socket socket = this.serverSocket.accept();
                socket.setSoTimeout(30000);
                RemoteLoggingListener listener = new RemoteLoggingListener(socket, this.pattern, this.path, this.appenders);
                Runtime.getRuntime().addShutdownHook(new ShutdownableShutdownHook(new Shutdownable[]{listener}));
                listener.start();
                Set<RemoteLoggingListener> set = this.listeners;
                synchronized (set) {
                    this.listeners.add(listener);
                    continue;
                }
            }
            catch (SocketTimeoutException ignore) {
                continue;
            }
            catch (Exception exc) {
                logger.logException(exc);
                continue;
            }
            finally {
                this.removeUnusedListeners();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnusedListeners() {
        Set<RemoteLoggingListener> set = this.listeners;
        synchronized (set) {
            ArrayList<RemoteLoggingListener> listenersToRemove = new ArrayList<RemoteLoggingListener>();
            for (RemoteLoggingListener listener : this.listeners) {
                if (!listener.isStarted() || listener.isRunning()) continue;
                listener.shutdown();
                listenersToRemove.add(listener);
                Runtime.getRuntime().removeShutdownHook(listener);
            }
            this.listeners.removeAll(listenersToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        this.removeUnusedListeners();
        Set<RemoteLoggingListener> set = this.listeners;
        synchronized (set) {
            for (RemoteLoggingListener listener : this.listeners) {
                listener.shutdown();
            }
            this.listeners.clear();
        }
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException exc) {
                logger.warn("Error closing server socket: %s", exc.getMessage());
                logger.logExceptionIfDebugEnabled(exc);
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdownRequested = true;
        this.cleanup();
    }
}

