/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLSocketNode;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;

public class ESLSocketLogger
extends Thread
implements Shutdownable {
    public static final int DEFAULT_PORT = 4560;
    static Logger logger = Logger.getLogger(ESLSocketLogger.class);
    private final int port;
    private Thread socketNodeThread;
    private boolean shutdownRequested = false;
    private Object shutdownLock = new Object();

    public ESLSocketLogger(int port) {
        this.port = port;
    }

    public ESLSocketLogger() {
        this(4560);
    }

    @Override
    public final void run() {
        try {
            logger.info((Object)("Listening on port " + this.port));
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (!this.isShutdownRequested()) {
                Socket socket = serverSocket.accept();
                LoggerRepository repository = LogManager.getLoggerRepository();
                this.socketNodeThread = new Thread(new ESLSocketNode(socket, repository));
                this.socketNodeThread.start();
            }
        }
        catch (Exception exc) {
            logger.warn((Object)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdownRequested = true;
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdownRequested() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.shutdownRequested;
        }
    }
}

