/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.log.ESLSocketLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class ESLRemoteLogger {
    static Logger logger;
    private static ArrayList<Integer> portList;
    private static HashMap<Integer, ESLSocketLogger> socketLoggerList;

    public static void main(String[] args) {
        portList = new ArrayList();
        socketLoggerList = new HashMap();
        int startIndex = 0;
        if (args.length == 0) {
            portList.add(4560);
        }
        for (int i = startIndex; i < args.length; ++i) {
            portList.add(Integer.parseInt(args[i]));
        }
        ESLRemoteLogger.initializeRootLogger();
        ESLRemoteLogger.startSocketLoggers();
    }

    private static void startSocketLoggers() {
        for (Integer port : portList) {
            socketLoggerList.put(port, new ESLSocketLogger(port));
            socketLoggerList.get(port).start();
        }
    }

    private static void initializeRootLogger() {
        logger = Logger.getRootLogger();
        logger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("[%p %c{1}]: %m%n")));
        try {
            logger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("[%p %d %c{1}]: %m%n"), "accesspoints.log"));
        }
        catch (IOException exc) {
            System.out.print("Could not load access log file accesspoints.log");
            return;
        }
    }

    public static void retrySocketNode(int port) {
        if (socketLoggerList.containsKey(port)) {
            socketLoggerList.get(port).shutdown();
            socketLoggerList.put(port, new ESLSocketLogger(port));
        }
    }
}

