/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.ExceptionUtils;
import at.mrdevelopment.toolkit.log.LoggingXMLWatchdog;
import java.io.File;
import java.sql.SQLException;
import java.util.IllegalFormatException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class ESLLogger {
    private static final String CONFIGURATION_DIRECTORY = "config";
    private static final String LOGGER_CONFIGURATION_FILE = "logging.xml";
    private static final long CONFIGURATION_RELOAD_DELAY = 10000L;
    private Logger logger;

    public static void initLogger(boolean configureAndWatch) {
        ESLLogger.initLogger(configureAndWatch, false);
    }

    public static void initLogger(boolean configureAndWatch, boolean ignoreRootLogLevel) {
        File configFile = new File(LOGGER_CONFIGURATION_FILE);
        File configFileAlternative = new File(CONFIGURATION_DIRECTORY, LOGGER_CONFIGURATION_FILE);
        if (configFile.exists()) {
            ESLLogger.configure(configureAndWatch, ignoreRootLogLevel, configFile);
        } else if (configFileAlternative.exists()) {
            ESLLogger.configure(configureAndWatch, ignoreRootLogLevel, configFileAlternative);
        } else {
            System.err.println(String.format("Missing logger configuration at '%s'", configFile.getAbsolutePath()));
            System.exit(1);
        }
    }

    public static void initDefaultLogger() {
        BasicConfigurator.configure();
    }

    private static void configure(boolean configureAndWatch, boolean ignoreRootLogLevel, File configFile) {
        if (configureAndWatch) {
            if (ignoreRootLogLevel) {
                ESLLogger.configureAndWatchButIgnoreRootLogLevel(configFile.getPath(), 10000L);
            } else {
                DOMConfigurator.configureAndWatch((String)configFile.getPath(), (long)10000L);
            }
        } else {
            DOMConfigurator.configure((String)configFile.getPath());
        }
    }

    private static void configureAndWatchButIgnoreRootLogLevel(String path, long delay) {
        LoggingXMLWatchdog xdog = new LoggingXMLWatchdog(path);
        xdog.setDelay(delay);
        xdog.start();
    }

    public static ESLLogger getLogger(Class<?> forClass) {
        return new ESLLogger(Logger.getLogger(forClass));
    }

    private ESLLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void trace(String message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)message);
        }
    }

    public void trace(String message, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.buildLogMessage(message, args));
        }
    }

    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)message);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.buildLogMessage(message, args));
        }
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)message);
        }
    }

    public void info(String message, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)this.buildLogMessage(message, args));
        }
    }

    public void warn(String message) {
        this.logger.warn((Object)message);
    }

    public void warn(String message, Object ... args) {
        this.logger.warn((Object)this.buildLogMessage(message, args));
    }

    public void error(String message) {
        this.logger.error((Object)message);
    }

    public void error(String message, Object ... args) {
        this.logger.error((Object)this.buildLogMessage(message, args));
    }

    public void logStackTrace() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Current stack trace:");
            StackTraceElement[] trace = new Throwable("Stack trace").getStackTrace();
            for (int index = 1; index < trace.length; ++index) {
                this.logger.info((Object)("\tat " + trace[index]));
            }
        }
    }

    public void logException(Throwable exc) {
        this.error("%s: %s", exc.getClass().getSimpleName(), exc.getMessage());
        if (exc instanceof SQLException) {
            SQLException sqlExc = (SQLException)exc;
            this.error("SQL state: %s", sqlExc.getSQLState());
            this.error("SQL vendor error code: %s", sqlExc.getErrorCode());
        }
        Throwable cause = exc.getCause();
        while (cause != null) {
            this.error("Caused by %s: %s", cause.getClass().getSimpleName(), cause.getMessage());
            if (!((cause = cause.getCause()) instanceof SQLException)) continue;
            SQLException sqlExc = (SQLException)cause;
            this.error("SQL state: %s", sqlExc.getSQLState());
            this.error("SQL vendor error code: %s", sqlExc.getErrorCode());
        }
        for (StackTraceElement stackTraceElement : ExceptionUtils.getRootCause(exc).getStackTrace()) {
            this.error(stackTraceElement.toString());
        }
    }

    public void logExceptionIfDebugEnabled(Throwable exc) {
        if (this.logger.isDebugEnabled()) {
            this.logException(exc);
        }
    }

    private String buildLogMessage(String message, Object ... args) {
        try {
            return message == null ? "" : String.format(message, args);
        }
        catch (IllegalFormatException exc) {
            this.logger.error((Object)exc.getMessage());
            return message;
        }
    }
}

