/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.log;

import at.mrdevelopment.toolkit.InitializationException;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class CustomFileAppender {
    private final FileAppender fileAppender;
    private Level oldLevel;

    public CustomFileAppender(String fileName, boolean debug) throws InitializationException {
        try {
            this.fileAppender = new FileAppender((Layout)new PatternLayout("[%p %d]: %m%n"), fileName);
            this.fileAppender.setName(fileName);
            this.fileAppender.setThreshold((Priority)(debug ? Level.DEBUG : Level.INFO));
            this.fileAppender.setImmediateFlush(true);
            this.oldLevel = Logger.getRootLogger().getLevel();
            Logger.getRootLogger().addAppender((Appender)this.fileAppender);
            Logger.getRootLogger().setLevel(debug ? Level.DEBUG : Level.INFO);
        }
        catch (IOException exc) {
            throw new InitializationException(exc);
        }
    }

    public void uninstall() {
        Logger.getRootLogger().setLevel(this.oldLevel);
        Logger.getRootLogger().removeAppender((Appender)this.fileAppender);
    }
}

