/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.licensing;

import at.mrdevelopment.toolkit.Base58;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.NetworkAddressUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Strings;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;

public class SystemSerial {
    static ESLLogger logger = ESLLogger.getLogger(SystemSerial.class);
    private final SystemSeed systemSeed;
    private final String systemSerial;

    public static void main(String[] args) throws InitializationException {
        System.out.println(SystemSerial.debugAllInterfaces());
    }

    public static String debugAllInterfaces() throws InitializationException {
        StringBuilder builder = new StringBuilder();
        builder.append("Default system serial:\n");
        builder.append("======================================\n\n");
        SystemSerial defaultSystemSerial = new SystemSerial();
        builder.append(defaultSystemSerial.getDebugString());
        builder.append("\n\nOther interfaces:\n");
        builder.append("======================================\n\n");
        for (SystemSerial systemSerial : SystemSerial.getAllNetworkInterfaceSystemSerials()) {
            builder.append(systemSerial.getDebugString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static List<SystemSerial> getAllNetworkInterfaceSystemSerials() {
        List<NetworkInterface> networkInterfaces = SystemSerial.getValidNetworkInterfaces();
        ArrayList<SystemSerial> systemSerials = new ArrayList<SystemSerial>(networkInterfaces.size());
        for (NetworkInterface networkInterface : networkInterfaces) {
            try {
                SystemSerial systemSerial = new SystemSerial(networkInterface);
                systemSerials.add(systemSerial);
            }
            catch (InitializationException exc) {
                logger.error(exc.getMessage());
            }
        }
        return Collections.unmodifiableList(systemSerials);
    }

    public SystemSerial() throws InitializationException {
        this((String)null);
    }

    public SystemSerial(String preferredInterface) throws InitializationException {
        this(Strings.isNullOrEmpty((String)preferredInterface) ? SystemSerial.findPrimaryNetworkInterface() : SystemSerial.findByNameOrIPv4Address(preferredInterface));
    }

    private SystemSerial(NetworkInterface networkInterface) throws InitializationException {
        this.systemSeed = this.calculateSystemSeed(networkInterface);
        this.systemSerial = this.calculateSystemSerial();
    }

    public SystemSerial(byte[] hardwareAddress) throws InitializationException {
        this.systemSeed = new SystemSeed(hardwareAddress);
        this.systemSerial = this.calculateSystemSerial();
    }

    public SystemSerial(SystemType type, int deviceId) throws InitializationException {
        this.systemSeed = new SystemSeed(type, deviceId);
        this.systemSerial = this.calculateSystemSerial();
    }

    public String getSystemSerial() {
        return this.systemSerial;
    }

    public SystemSeed getSystemSeed() {
        return this.systemSeed;
    }

    public static boolean verifyChecksum(String systemSerial) {
        if (systemSerial.length() < 2) {
            return false;
        }
        String encoded = systemSerial.substring(0, systemSerial.length() - 1);
        char checksum = systemSerial.charAt(systemSerial.length() - 1);
        return Base58.calculateCheckSum(encoded) == checksum;
    }

    private static NetworkInterface findByNameOrIPv4Address(String preferredInterface) throws InitializationException {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByName(preferredInterface);
            if (SystemSerial.isValidInterface(networkInterface)) {
                return networkInterface;
            }
            InetAddress addr = InetAddress.getByName(preferredInterface);
            networkInterface = NetworkInterface.getByInetAddress(addr);
            if (SystemSerial.isValidInterface(networkInterface)) {
                return networkInterface;
            }
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        logger.info("Interface %s not found - fallback to primary interface", preferredInterface);
        return SystemSerial.findPrimaryNetworkInterface();
    }

    public static List<NetworkInterface> getValidNetworkInterfaces() {
        ArrayList<NetworkInterface> validInterfaces = new ArrayList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                boolean valid = SystemSerial.isValidInterface(networkInterface);
                String systemSerial = null;
                if (valid) {
                    systemSerial = new SystemSerial(networkInterface.getHardwareAddress()).getSystemSerial();
                    validInterfaces.add(networkInterface);
                }
                logger.info("%s interface %s: up=%b loopback=%b virtual=%b point-to-point=%b mac=%s system-serial=%s name=%s", valid ? "Found" : "Ignoring", networkInterface.getName(), networkInterface.isUp(), networkInterface.isLoopback(), networkInterface.isVirtual(), networkInterface.isPointToPoint(), NetworkAddressUtils.hardwareAddressToString(networkInterface.getHardwareAddress()), systemSerial, networkInterface.getDisplayName());
            }
        }
        catch (Exception exc) {
            logger.logException(exc);
        }
        return Collections.unmodifiableList(validInterfaces);
    }

    public List<SystemSerial> getAllSystemSerials() {
        if (this.systemSeed.systemSeedType == SystemSeedType.GENERATED_FROM_NETWORK_INTERFACE) {
            return SystemSerial.getAllNetworkInterfaceSystemSerials();
        }
        return Collections.singletonList(this);
    }

    private static NetworkInterface findPrimaryNetworkInterface() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (!SystemSerial.isValidInterface(networkInterface)) continue;
                return networkInterface;
            }
            return null;
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            return null;
        }
    }

    private static boolean isValidInterface(NetworkInterface networkInterface) throws SocketException {
        return networkInterface != null && !networkInterface.isLoopback() && !networkInterface.isVirtual() && !networkInterface.isPointToPoint() && networkInterface.getHardwareAddress() != null && networkInterface.getHardwareAddress().length == 6 && SystemSerial.hasIPv4Address(networkInterface);
    }

    private static boolean hasIPv4Address(NetworkInterface networkInterface) {
        for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
            InetAddress address = interfaceAddress.getAddress();
            if (!(address instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    private SystemSeed calculateSystemSeed(NetworkInterface networkInterface) {
        if (networkInterface == null) {
            return null;
        }
        try {
            return new SystemSeed(networkInterface);
        }
        catch (Exception exc) {
            logger.logExceptionIfDebugEnabled(exc);
            return null;
        }
    }

    private String calculateSystemSerial() throws InitializationException {
        if (this.systemSeed == null || this.systemSeed.seedData == null) {
            throw new InitializationException("Could not generate system serial", new Object[0]);
        }
        byte[] hash = Arrays.copyOf(DigestUtils.sha256((byte[])this.systemSeed.seedData), 13);
        byte[] input = ArrayUtils.addAll((byte[])this.systemSeed.getSystemSeedType().getHeader(), (byte[])hash);
        return Base58.encodeWithChecksum(input);
    }

    public String getDebugString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Interface:     %s%n", this.systemSeed.interfaceName));
        builder.append(String.format("Name:          %s%n", this.systemSeed.interfaceDisplayName));
        builder.append(String.format("MAC address:   %s%n", NetworkAddressUtils.hardwareAddressToString(this.systemSeed.seedData)));
        builder.append(String.format("System serial: %s%n", this.getSystemSerial()));
        return builder.toString();
    }

    public static class SystemSeed {
        private final SystemSeedType systemSeedType;
        private final String interfaceName;
        private final String interfaceDisplayName;
        private final byte[] seedData;

        public SystemSeed(SystemType type, int deviceId) {
            this.systemSeedType = SystemSeedType.GENERATED_FROM_DEVICE_ID;
            this.interfaceName = String.valueOf(deviceId);
            this.interfaceDisplayName = String.format("%s: %d", type.getName(), deviceId);
            this.seedData = ByteBuffer.allocate(4 + type.getData().length).putInt(deviceId).put(type.getData()).array();
        }

        public SystemSeed(byte[] hardwareAddress) {
            this.systemSeedType = SystemSeedType.GENERATED_FROM_NETWORK_INTERFACE;
            this.interfaceName = "unknown";
            this.interfaceDisplayName = "Unknown interface";
            this.seedData = hardwareAddress;
        }

        public SystemSeed(NetworkInterface networkInterface) throws SocketException {
            this.systemSeedType = SystemSeedType.GENERATED_FROM_NETWORK_INTERFACE;
            this.interfaceName = networkInterface.getName();
            this.interfaceDisplayName = networkInterface.getDisplayName();
            this.seedData = networkInterface.getHardwareAddress();
        }

        public SystemSeedType getSystemSeedType() {
            return this.systemSeedType;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public String getInterfaceDisplayName() {
            return this.interfaceDisplayName;
        }

        public byte[] getSeedData() {
            return this.seedData;
        }

        public String toString() {
            return String.format("%s (%s) %s", this.interfaceName, this.interfaceDisplayName, NetworkAddressUtils.hardwareAddressToString(this.seedData));
        }
    }

    public static enum SystemType {
        CORE_APPLIANCE("Core-Appliance", new byte[]{1}),
        CORE_APPLIANCE_MINI("Core-Appliance-Mini", new byte[]{2});

        private final String name;
        private final byte[] data;

        private SystemType(String name, byte[] data) {
            this.name = name;
            this.data = name.getBytes(Charset.forName("UTF-8"));
        }

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    private static enum SystemSeedType {
        GENERATED_FROM_NETWORK_INTERFACE(new byte[]{-13}),
        GENERATED_FROM_DEVICE_ID(new byte[]{-12});

        private final byte[] header;

        private SystemSeedType(byte[] header) {
            this.header = header;
        }

        public byte[] getHeader() {
            return this.header;
        }
    }
}

