/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.lancom;

import java.util.HashMap;
import java.util.Map;

public enum LancomWePaperChannel {
    CHANNEL_AUTO(-1, "Auto"),
    CHANNEL_0(0, "2404MHz"),
    CHANNEL_1(1, "2410MHz"),
    CHANNEL_2(2, "2422MHz"),
    CHANNEL_3(3, "2425MHz"),
    CHANNEL_4(4, "2442MHz"),
    CHANNEL_5(5, "2450MHz"),
    CHANNEL_6(6, "2462MHz"),
    CHANNEL_7(7, "2470MHz"),
    CHANNEL_8(8, "2474MHz"),
    CHANNEL_9(9, "2477MHz"),
    CHANNEL_10(10, "2480MHz");

    static final Map<String, LancomWePaperChannel> lookup;
    private final int id;
    private final String identifier;

    static final Map<String, LancomWePaperChannel> createLookup() {
        HashMap<String, LancomWePaperChannel> lut = new HashMap<String, LancomWePaperChannel>();
        for (LancomWePaperChannel ch : LancomWePaperChannel.values()) {
            lut.put(ch.identifier, ch);
        }
        return lut;
    }

    private LancomWePaperChannel(int channelId, String ident) {
        this.id = channelId;
        this.identifier = ident;
    }

    public static LancomWePaperChannel getFromString(String identifier) {
        return lookup.get(identifier);
    }

    public int getId() {
        return this.id;
    }

    static {
        lookup = LancomWePaperChannel.createLookup();
    }
}

