/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.lancom;

import at.mrdevelopment.toolkit.NetworkAddressUtils;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.lancom.ConnectResult;
import at.mrdevelopment.toolkit.lancom.LancomConfigClient;
import at.mrdevelopment.toolkit.lancom.LancomConfigOption;
import at.mrdevelopment.toolkit.lancom.LancomConfigParser;
import at.mrdevelopment.toolkit.lancom.LancomConfiguration;
import at.mrdevelopment.toolkit.lancom.LancomConnectException;
import at.mrdevelopment.toolkit.lancom.LancomDiscoverySettings;
import at.mrdevelopment.toolkit.lancom.LancomException;
import at.mrdevelopment.toolkit.lancom.LancomTFTPResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.sshtools.ssh.SshException;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPClient;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPReadRQPacket;

public class LancomDiscoveryClient
implements Shutdownable {
    private static final ESLLogger logger = ESLLogger.getLogger(LancomDiscoveryClient.class);
    private static final boolean DEFAULT_IGNORE_DEVICES_POLICY = true;
    private static final int DEFAULT_PORT = 69;
    private static final int DEFAULT_TIMEOUT_IN_MILLISECONDS = 400;
    private static final int DEFAULT_MAX_TIMEOUTS = 5;
    private static final int DEFAULT_DURATION_IN_SECONDS = 4;
    private static final String DEFAULT_FILE_TO_REQUEST = "sysinfo";
    private static final int PACKETS_PER_RESPONSE = 4;
    private int port;
    private String fileToRequest;
    private int timeoutInMilliseconds;
    private int maxTimeouts;
    private int durationInSeconds;
    private boolean ignoreResponseWithouApId;
    private LancomConfigClient configClient;
    private volatile boolean shutdownRequested;

    public LancomDiscoveryClient(boolean ignoreResponseWithouApId) throws SshException {
        this(69, 400, 5, 4, ignoreResponseWithouApId);
    }

    public LancomDiscoveryClient() throws SshException {
        this(4);
    }

    public LancomDiscoveryClient(int durationInSeconds) throws SshException {
        this(400, 5, durationInSeconds);
    }

    public LancomDiscoveryClient(int timeoutInMilliSeconds, int maxTimeouts, int SearchDurationInSecounds) throws SshException {
        this(69, timeoutInMilliSeconds, maxTimeouts, SearchDurationInSecounds, true);
    }

    public LancomDiscoveryClient(LancomDiscoverySettings settings) throws SshException {
        this(settings.port, settings.timeoutInMilliseconds, settings.maxTimeouts, settings.durationInSeconds, true);
        this.setCredentials(settings.getCredentials().getUser(), settings.getCredentials().getPassword());
    }

    public LancomDiscoveryClient(int port, int timeoutInMilliSeconds, int maxTimeouts, int durationInSecounds, boolean ignoreResponseWithouApId) throws SshException {
        this.port = port;
        this.timeoutInMilliseconds = timeoutInMilliSeconds;
        this.maxTimeouts = maxTimeouts;
        this.durationInSeconds = durationInSecounds;
        this.fileToRequest = DEFAULT_FILE_TO_REQUEST;
        this.ignoreResponseWithouApId = ignoreResponseWithouApId;
        this.configClient = new LancomConfigClient();
        this.shutdownRequested = false;
    }

    public void setCredentials(String username, String password) {
        this.configClient.setLogin(username, password);
    }

    public List<LancomConfiguration> search() throws IOException {
        return this.search(null);
    }

    public List<LancomConfiguration> search(Collection<Integer> apIdWhitelist) throws IOException {
        LinkedList<LancomConfiguration> result = new LinkedList<LancomConfiguration>();
        LinkedList<InterfaceAddress> interfaces = this.getInterfaces();
        if (interfaces.size() == 0) {
            throw new IOException("No viable Network Interface Found");
        }
        long discoveryTime = System.currentTimeMillis();
        for (LancomTFTPResponse response : this.searchAPs(interfaces).values()) {
            if (this.shutdownRequested) continue;
            LancomConfiguration info = LancomConfigParser.parseSysinfo(response.getMessage());
            if (StringUtils.isBlank((String)info.getApId()) && this.ignoreResponseWithouApId) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Lancom Device without AP_ID dedected, %s (%s) will be ignored", !info.getName().isEmpty() ? info.getName() : "<COULDN'T ACQUIRE NAME>", !info.getAddress().isEmpty() ? info.getAddress() : "<COULDN'T ACQUIRE ADDRESS>");
                continue;
            }
            if (StringUtils.isBlank((String)info.getAddress()) || StringUtils.isBlank((String)info.getSubnetMask())) {
                logger.warn("No address data for Lancom AP: %s. Will be ignored.", info.getApId());
                continue;
            }
            info.setDiscoveryTime(discoveryTime);
            result.add(info);
            if (apIdWhitelist != null && !apIdWhitelist.contains(new Integer(info.getApId()))) continue;
            this.completeConfig(info);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeConfig(LancomConfiguration apConfig) {
        ConnectResult result = ConnectResult.SUCCESS;
        try {
            result = this.configClient.connect(apConfig.getAddress(), Integer.parseInt(apConfig.getSshPort()));
            if (result == ConnectResult.SUCCESS) {
                this.configClient.completeConfig(apConfig);
            }
        }
        catch (LancomConnectException exc) {
            result = exc.getResult();
            logger.info("Could not establish SSH connection with AP %s on address %s, cause: %s", apConfig.getApId(), apConfig.getAddress(), exc.getMessage());
            logger.logExceptionIfDebugEnabled(exc);
        }
        catch (LancomException le) {
            logger.warn("Could not complete config for AP %s on address %s, cause: %s", apConfig.getApId(), apConfig.getAddress(), le.getMessage());
            logger.logExceptionIfDebugEnabled(le);
        }
        finally {
            apConfig.set(LancomConfigOption.AUTHENTICATION_RESULT, result.name());
            this.configClient.disconnect();
        }
    }

    private LinkedList<InterfaceAddress> getInterfaces() {
        LinkedList<InterfaceAddress> interfaces = new LinkedList<InterfaceAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface netInt = nets.nextElement();
                if (!netInt.isUp() || netInt.isLoopback()) continue;
                for (InterfaceAddress currentInterface : netInt.getInterfaceAddresses()) {
                    if (currentInterface == null || currentInterface.getBroadcast() == null) continue;
                    interfaces.add(currentInterface);
                }
            }
        }
        catch (SocketException exc) {
            logger.error("Got: '" + exc.getMessage() + "' while trying to get Network Interfaces");
            logger.logExceptionIfDebugEnabled(exc);
            interfaces.clear();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Interface summary - %d:", interfaces.size());
            for (InterfaceAddress addr : interfaces) {
                logger.debug("Address = %s, broadcast = %s, networkPrefixLength = %d.", addr.getAddress().toString(), addr.getBroadcast().toString(), addr.getNetworkPrefixLength());
            }
        }
        return interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<InetAddress, LancomTFTPResponse> searchAPs(LinkedList<InterfaceAddress> interfaces) {
        HashMap<InetAddress, LancomTFTPResponse> response = new HashMap<InetAddress, LancomTFTPResponse>();
        for (InterfaceAddress interfaceAddress : interfaces) {
            if (this.shutdownRequested) continue;
            TFTPClient client = new TFTPClient();
            client.setDefaultTimeout(this.timeoutInMilliseconds);
            client.setMaxTimeouts(this.maxTimeouts);
            try {
                this.broadcastRequest(client, interfaceAddress);
                this.registerResponders(client, response);
            }
            catch (SocketException exc) {
                logger.error(exc.getMessage() + " on Interface " + interfaceAddress.toString());
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (TFTPPacketException exc) {
                logger.error(exc.getMessage() + " on Interface " + interfaceAddress.toString());
                logger.logExceptionIfDebugEnabled(exc);
            }
            catch (IOException exc) {
                logger.error(exc.getMessage() + " on Interface " + interfaceAddress.toString());
                logger.logExceptionIfDebugEnabled(exc);
            }
            finally {
                if (!client.isOpen()) continue;
                client.close();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RESULT:");
            for (Map.Entry entry : response.entrySet()) {
                logger.debug("========" + entry.getKey() + "========");
                logger.debug("==== received packets: " + String.valueOf(((LancomTFTPResponse)entry.getValue()).getPacketCount()) + " ====");
                logger.debug(((LancomTFTPResponse)entry.getValue()).getMessage() + "\r\r\r");
            }
        }
        return response;
    }

    private void broadcastRequest(TFTPClient client, InterfaceAddress ifAddr) throws IOException, TFTPPacketException {
        InetAddress broadcastAddress;
        client.open();
        if (ifAddr.getAddress() instanceof Inet4Address) {
            broadcastAddress = NetworkAddressUtils.calculateBroadcastAddress((Inet4Address)ifAddr.getAddress(), ifAddr.getNetworkPrefixLength());
            if (ifAddr.getNetworkPrefixLength() > 32 || ifAddr.getNetworkPrefixLength() < 0) {
                logger.warn("The netmask - %s for interface %s might be faulty (prefix length = %d). This might limit or completely block the discovery of Lancom APs.", ifAddr.getBroadcast().toString(), ifAddr.getAddress().toString(), ifAddr.getNetworkPrefixLength());
            }
        } else {
            broadcastAddress = ifAddr.getBroadcast();
        }
        TFTPReadRQPacket req = new TFTPReadRQPacket(broadcastAddress, this.port, this.fileToRequest);
        client.send((TFTPPacket)req);
    }

    private void registerResponders(TFTPClient client, HashMap<InetAddress, LancomTFTPResponse> response) throws IOException, TFTPPacketException {
        TFTPPacket packet = null;
        TFTPDataPacket data = null;
        long stop = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.durationInSeconds);
        while (!this.shutdownRequested && stop > System.currentTimeMillis()) {
            try {
                packet = client.receive();
                if (packet.getType() != 3) continue;
                data = (TFTPDataPacket)packet;
                client.send((TFTPPacket)new TFTPAckPacket(data.getAddress(), data.getPort(), data.getBlockNumber()));
                if (!response.containsKey(data.getAddress())) {
                    response.put(data.getAddress(), new LancomTFTPResponse());
                }
                if (response.get(data.getAddress()).getPacketCount() >= 4) continue;
                response.get(data.getAddress()).append(new String(data.getData(), data.getDataOffset(), data.getDataLength(), "US-ASCII"));
            }
            catch (SocketTimeoutException exc) {}
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFile() {
        return this.fileToRequest;
    }

    public void setFile(String file) {
        this.fileToRequest = file;
    }

    public int getTimeout() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeout(int timeout) {
        this.timeoutInMilliseconds = timeout;
    }

    public int getMaxTimeouts() {
        return this.maxTimeouts;
    }

    public void setMaxTimeouts(int maxTimeouts) {
        this.maxTimeouts = maxTimeouts;
    }

    public int getDuration() {
        return this.durationInSeconds;
    }

    public void setDuration(int durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
    }

    @Override
    public void shutdown() {
        this.shutdownRequested = true;
    }
}

