/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.lancom;

import at.mrdevelopment.toolkit.lancom.LancomConfigOption;
import java.util.HashMap;
import java.util.Iterator;

public class LancomConfiguration
implements Iterable<String> {
    private final HashMap<LancomConfigOption, String> entrys = new HashMap();
    private long discoveryTime = 0L;

    public LancomConfiguration() {
        for (LancomConfigOption option : LancomConfigOption.getAvalableOptions()) {
            this.entrys.put(option, "");
        }
    }

    public long getDiscoveryTime() {
        return this.discoveryTime;
    }

    public void setDiscoveryTime(long discoveryTime) {
        this.discoveryTime = discoveryTime;
    }

    public void update(LancomConfiguration other) {
        for (LancomConfigOption option : LancomConfigOption.getAvalableOptions()) {
            if (other.get(option).isEmpty()) continue;
            this.set(option, other.get(option));
        }
    }

    public void set(LancomConfigOption option, String value) {
        this.entrys.put(option, value);
    }

    public String get(LancomConfigOption option) {
        return this.entrys.get((Object)option);
    }

    @Override
    public Iterator<String> iterator() {
        return this.entrys.values().iterator();
    }

    public String getApId() {
        return this.get(LancomConfigOption.AP_ID);
    }

    public void setApId(String id) {
        this.set(LancomConfigOption.AP_ID, id);
    }

    public String getDevice() {
        return this.get(LancomConfigOption.DEVICE);
    }

    public String getSerialNumber() {
        return this.get(LancomConfigOption.SERIAL_NUMBER);
    }

    public void setSerialNumber(String serialNumber) {
        this.set(LancomConfigOption.SERIAL_NUMBER, serialNumber);
    }

    public String getName() {
        return this.get(LancomConfigOption.NAME);
    }

    public void setName(String name) {
        this.set(LancomConfigOption.NAME, name);
    }

    public String getWirelessChannel() {
        return this.get(LancomConfigOption.WIRELESS_CHANNEL);
    }

    public void setWirelessChannel(String channel) {
        this.set(LancomConfigOption.WIRELESS_CHANNEL, channel);
    }

    public String getFirmwareVersion() {
        return this.get(LancomConfigOption.FIRMWARE_VERSION);
    }

    public void setFirmwareVersion(String version) {
        this.set(LancomConfigOption.FIRMWARE_VERSION, version);
    }

    public String getAddress() {
        return this.get(LancomConfigOption.IP_ADDRESS);
    }

    public void setAddress(String address) {
        this.set(LancomConfigOption.IP_ADDRESS, address);
    }

    public String getSubnetMask() {
        return this.get(LancomConfigOption.SUBNET_MASK);
    }

    public void setSubnetMask(String subnetMask) {
        this.set(LancomConfigOption.SUBNET_MASK, subnetMask);
    }

    public String getGatewayAddress() {
        return this.get(LancomConfigOption.GATEWAY_ADDRESS);
    }

    public void setGatewayAddress(String address) {
        this.set(LancomConfigOption.GATEWAY_ADDRESS, address);
    }

    public String getDnsAddress() {
        return this.get(LancomConfigOption.DNS_ADDRESS);
    }

    public void setDnsAddress(String address) {
        this.set(LancomConfigOption.DNS_ADDRESS, address);
    }

    public String getSshPort() {
        return this.get(LancomConfigOption.SSH_PORT);
    }

    public void setSshPort(String port) {
        this.set(LancomConfigOption.SSH_PORT, port);
    }

    public String getWePort() {
        return this.get(LancomConfigOption.WIRELESS_E_PAPER_PORT);
    }

    public void setWePort(String port) {
        this.set(LancomConfigOption.WIRELESS_E_PAPER_PORT, port);
    }

    public String getControllerAddress() {
        return this.get(LancomConfigOption.CONTROLLER_IP);
    }

    public void setControllerAddress(String address) {
        this.set(LancomConfigOption.CONTROLLER_IP, address);
    }

    public String getHttpPort() {
        return this.get(LancomConfigOption.HTTP_PORT);
    }

    public void setHttpPort(String port) {
        this.set(LancomConfigOption.HTTP_PORT, port);
    }

    public String getHttpsPort() {
        return this.get(LancomConfigOption.HTTPS_PORT);
    }

    public void setHttpsPort(String port) {
        this.set(LancomConfigOption.HTTPS_PORT, port);
    }

    public boolean getWeOperating() {
        return this.get(LancomConfigOption.WIRELESS_E_PAPER_OPERATING).equals("Manual");
    }

    public void setWeOperating(boolean operating) {
        if (operating) {
            this.set(LancomConfigOption.WIRELESS_E_PAPER_OPERATING, "Manual");
        } else {
            this.set(LancomConfigOption.WIRELESS_E_PAPER_OPERATING, "Off");
        }
    }
}

