/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.lancom;

import at.mrdevelopment.toolkit.lancom.LancomConfigInstruction;
import at.mrdevelopment.toolkit.lancom.LancomConfigOption;
import at.mrdevelopment.toolkit.lancom.LancomConfiguration;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NotImplementedException;

public class LancomConfigParser {
    private static final ESLLogger logger = ESLLogger.getLogger(LancomConfigParser.class);
    private static final PatternHolder[] sysinfoPattern = new PatternHolder[]{new PatternHolder(LancomConfigOption.SERIAL_NUMBER, Pattern.compile("SERIAL-NUMBER:[ ]+([0-9]+)")), new PatternHolder(LancomConfigOption.DEVICE, Pattern.compile("DEVICE:[ ]+(.+)")), new PatternHolder(LancomConfigOption.IP_ADDRESS, Pattern.compile("IP-ADDRESS:[ ]+([0-9.]+)")), new PatternHolder(LancomConfigOption.SUBNET_MASK, Pattern.compile("IP-NETMASK:[ ]+([0-9.]+)")), new PatternHolder(LancomConfigOption.AP_ID, Pattern.compile("WePaper AP-ID:[ ]+([0-9]+)")), new PatternHolder(LancomConfigOption.WIRELESS_E_PAPER_PORT, Pattern.compile("WePaper-PORT:[ ]+([0-9]+)"), "-1"), new PatternHolder(LancomConfigOption.NAME, Pattern.compile("NAME:[ ]+(\\S.+)"), "<NO NAME>"), new PatternHolder(LancomConfigOption.FIRMWARE_VERSION, Pattern.compile("VERSION:[ ]+([0-9.]+)")), new PatternHolder(LancomConfigOption.SSH_PORT, Pattern.compile("SSH-PORT:[ ]+([0-9]+)")), new PatternHolder(LancomConfigOption.HTTP_PORT, Pattern.compile("HTTP-PORT:[ ]+([0-9]+)")), new PatternHolder(LancomConfigOption.HTTPS_PORT, Pattern.compile("HTTPS-PORT:[ ]+([0-9]+)"))};
    private static final HashMap<LancomConfigInstruction, Pattern> shellPattern = LancomConfigParser.createShellPattern();
    private static final Pattern asciiControlChars = Pattern.compile("[\\x00-\\x09\\x0B-\\x0C\\x0E-\\x1F]");

    private static HashMap<LancomConfigInstruction, Pattern> createShellPattern() {
        HashMap<LancomConfigInstruction, Pattern> patternMap = new HashMap<LancomConfigInstruction, Pattern>();
        patternMap.put(LancomConfigInstruction.CONTROLLER_IP, Pattern.compile("Controller-IP[ ]+INFO:[ ]+([0-9.]+)"));
        patternMap.put(LancomConfigInstruction.WIRELESS_CHANNEL_GET, Pattern.compile("Current-Channel[ ]+INFO:[ ]+([0-9]+)MHz"));
        patternMap.put(LancomConfigInstruction.DNS_ADDRESS, Pattern.compile("Local[ ]+0[ ]+([0-9.]+)"));
        patternMap.put(LancomConfigInstruction.GATEWAY_ADDRESS, Pattern.compile("255.255.255.255[ ]+0.0.0.0[ ]+0[ ]+([0-9.]+)"));
        patternMap.put(LancomConfigInstruction.WIRELESS_E_PAPER_OPERATING, Pattern.compile("Operating[ ]+VALUE:[ ]+(.+)"));
        return patternMap;
    }

    private LancomConfigParser() {
    }

    public static LancomConfiguration parseSysinfo(String rawResponse) throws IOException {
        Matcher asciiFilter = asciiControlChars.matcher(rawResponse);
        return LancomConfigParser.createConfig(asciiFilter.replaceAll(""));
    }

    private static LancomConfiguration createConfig(String rawInfo) {
        LancomConfiguration config = new LancomConfiguration();
        Matcher matcher = null;
        for (PatternHolder ph : sysinfoPattern) {
            matcher = ph.pattern.matcher(rawInfo);
            if (matcher.find()) {
                config.set(ph.option, matcher.group(1));
                continue;
            }
            if (!ph.hasNotFoundValue) continue;
            config.set(ph.option, ph.notFoundValue);
        }
        return config;
    }

    public static String ParseSetting(String response, LancomConfigInstruction instruction) {
        String result;
        if (!shellPattern.containsKey((Object)instruction)) {
            throw new NotImplementedException();
        }
        Matcher match = shellPattern.get((Object)instruction).matcher(response);
        if (match.find()) {
            result = match.group(1);
        } else {
            logger.debug(String.format("Could not recive %s Value", instruction.name()));
            result = "";
        }
        return result;
    }

    private static class PatternHolder {
        Pattern pattern;
        LancomConfigOption option;
        boolean hasNotFoundValue;
        String notFoundValue;

        PatternHolder(LancomConfigOption option, Pattern pattern) {
            this.init(option, pattern, false, null);
        }

        PatternHolder(LancomConfigOption option, Pattern pattern, String notFoundValue) {
            this.init(option, pattern, true, notFoundValue);
        }

        private void init(LancomConfigOption option, Pattern pattern, boolean hasNotFoundValue, String notFoundValue) {
            this.option = option;
            this.pattern = pattern;
            this.hasNotFoundValue = hasNotFoundValue;
            this.notFoundValue = notFoundValue;
        }
    }
}

