/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.lancom;

import at.mrdevelopment.toolkit.lancom.OptionType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public enum LancomConfigOption {
    DEVICE("Device", OptionType.ALPHA_NUMERIC, false, false, -1),
    SERIAL_NUMBER("Serial", OptionType.ALPHA_NUMERIC, false, false, -1),
    CONTROLLER_IP("Controller address", OptionType.DOTTED_DECIMAL_ADDRESS, false, false, -1),
    NAME("Name", OptionType.ALPHA_NUMERIC, true, false, 0),
    AP_ID("AP ID", OptionType.ALPHA_NUMERIC, false, false, -1),
    WIRELESS_E_PAPER_PORT("Wireless ePaper Port", OptionType.ALPHA_NUMERIC, true, true, 3),
    WIRELESS_CHANNEL("Wireless ePaper Channel", OptionType.CHANNEL, true, true, 1),
    FIRMWARE_VERSION("Firmware version", OptionType.ALPHA_NUMERIC, false, false, -1),
    IP_ADDRESS("IP Address", OptionType.DOTTED_DECIMAL_ADDRESS, true, false, 2),
    SUBNET_MASK("Subnetmask", OptionType.DOTTED_DECIMAL_ADDRESS, true, true, 4),
    GATEWAY_ADDRESS("Gateway", OptionType.DOTTED_DECIMAL_ADDRESS, true, true, 5),
    DNS_ADDRESS("DNS Address", OptionType.DOTTED_DECIMAL_ADDRESS, true, true, 7),
    SSH_PORT("SSH Port", OptionType.PORT, true, false, 6),
    HTTP_PORT("HTTP Port", OptionType.PORT, true, false, 8),
    HTTPS_PORT("HTTPS Port", OptionType.PORT, true, false, 9),
    WIRELESS_E_PAPER_OPERATING("Wireless ePaper Operating", OptionType.ALPHA_NUMERIC, false, true, -1),
    AUTHENTICATION_RESULT("Authentication result", OptionType.ALPHA_NUMERIC, false, true, -1);

    private static final HashMap<String, LancomConfigOption> lookup;
    public final String displayName;
    public final OptionType optionType;
    public final boolean isConfigurable;
    public final boolean mayBeEmpty;
    public final int GUIOrder;

    public static LancomConfigOption getFromString(String name) {
        return lookup.get(name);
    }

    public static Iterable<LancomConfigOption> getAvalableOptions() {
        return lookup.values();
    }

    public static Set<LancomConfigOption> getConfigurable() {
        HashSet<LancomConfigOption> configableOptions = new HashSet<LancomConfigOption>();
        for (LancomConfigOption option : lookup.values()) {
            if (!option.isConfigurable) continue;
            configableOptions.add(option);
        }
        return configableOptions;
    }

    private LancomConfigOption(String name, OptionType type, boolean configurable, boolean canBeEmpty, int order) {
        this.displayName = name;
        this.optionType = type;
        this.isConfigurable = configurable;
        this.mayBeEmpty = canBeEmpty;
        this.GUIOrder = order;
    }

    static {
        lookup = new HashMap();
        for (LancomConfigOption option : LancomConfigOption.values()) {
            lookup.put(option.name(), option);
        }
    }
}

