/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.lancom;

import at.mrdevelopment.toolkit.lancom.LancomConstants;
import java.util.regex.Pattern;

public enum LancomConfigInstruction {
    WIRELESS_CHANNEL_SET("/Setup/Wireless-ePaper/", "Channel", LancomConstants.SET_OK),
    WIRELESS_CHANNEL_GET("/Status/Wireless-ePaper/", "Current-Channel", null),
    HOSTNAME("/Setup/WAN/IP-List/", " Internet {Gateway}", LancomConstants.SET_OK),
    IP_ADDRESS("/Setup/TCP-IP/Network-list/", "INTRANET", LancomConstants.SET_OK),
    SUBNET_MASK("/Setup/TCP-IP/Network-list/", "INTRANET", LancomConstants.SET_OK),
    GATEWAY_ADDRESS("/Setup/IP-Router/IP-Routing-Table/", "255.255.255.255 {IP-Netmask} 0.0.0.0 {Peer-or-IP}", LancomConstants.SET_OK),
    DNS_ADDRESS("/Setup/DNS/DNS-List/", "Local {IP-Address}", LancomConstants.SET_OK),
    SSH_PORT("/Setup/Config/SSH/", "Port", LancomConstants.SET_OK),
    PORT("/Setup/Wireless-ePaper/", "Port", LancomConstants.SET_OK),
    CONTROLLER_IP("/Status/Wireless-ePaper/", "Controller-IP", LancomConstants.SET_OK),
    WIRELESS_E_PAPER_OPERATING("/Setup/Wireless-ePaper/", "Operating", LancomConstants.SET_OK),
    NAME("/Setup/", "Name", LancomConstants.SET_OK),
    PASSWORD("", "passwd -n ", LancomConstants.PASSWORD_CHANGED),
    REBOOT("/Other/", "Cold-Boot", null),
    LOAD_FIRMWARE("", "LoadFirmware -n", LancomConstants.SET_OK);

    public final String path;
    public final String command;
    public final Pattern successMsg;

    private LancomConfigInstruction(String path, String command, Pattern successMsg) {
        this.path = path;
        this.command = command;
        this.successMsg = successMsg;
    }

    public static LancomConfigInstruction createFromString(String name) {
        return LancomConfigInstruction.valueOf(name);
    }
}

