/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.lancom;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.lancom.ConnectResult;
import at.mrdevelopment.toolkit.lancom.LancomConfigInstruction;
import at.mrdevelopment.toolkit.lancom.LancomConfigOption;
import at.mrdevelopment.toolkit.lancom.LancomConfigParser;
import at.mrdevelopment.toolkit.lancom.LancomConfiguration;
import at.mrdevelopment.toolkit.lancom.LancomConnectException;
import at.mrdevelopment.toolkit.lancom.LancomException;
import at.mrdevelopment.toolkit.lancom.SshCredentials;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.sshtools.net.SocketTransport;
import com.sshtools.ssh.ChannelOpenException;
import com.sshtools.ssh.PasswordAuthentication;
import com.sshtools.ssh.SshAuthentication;
import com.sshtools.ssh.SshClient;
import com.sshtools.ssh.SshConnector;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.SshSession;
import com.sshtools.ssh.SshTransport;
import com.sshtools.util.IOStreamConnector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class LancomConfigClient {
    private static ESLLogger logger = ESLLogger.getLogger(LancomConfigClient.class);
    private SshConnector connector;
    private ByteArrayOutputStream response = new ByteArrayOutputStream();
    private IOStreamConnector iosc;
    private SshCredentials credentials;
    private String currentAddress;
    private int currentPort;
    private SshClient client;
    private SshSession session;

    public LancomConfigClient() throws SshException {
        this.connector = SshConnector.createInstance();
    }

    public LancomConfigClient(SshCredentials creds) throws SshException {
        this.connector = SshConnector.createInstance();
        this.credentials = creds;
    }

    public ConnectResult connect(String address, int port) throws LancomConnectException {
        ConnectResult result = ConnectResult.CONNECT_ERROR;
        this.session = null;
        logger.debug("Connecting to " + address);
        this.currentAddress = address;
        this.currentPort = port;
        try {
            SocketTransport st = new SocketTransport(address, port);
            st.setSoTimeout(5000);
            this.connector.getContext().setPreferredKeyExchange("diffie-hellman-group-exchange-sha256");
            this.client = this.connector.connect((SshTransport)st, "imago-server");
            PasswordAuthentication pwd = new PasswordAuthentication();
            pwd.setUsername(this.credentials.getUser());
            pwd.setPassword(this.credentials.getPassword());
            result = ConnectResult.AUTHENTICATION_ERROR;
            int connectionSate = this.client.authenticate((SshAuthentication)pwd);
            if (connectionSate == 1) {
                boolean pseudoTerminal;
                result = ConnectResult.OTHER_ERROR;
                this.session = this.client.openSessionChannel();
                boolean bl = pseudoTerminal = this.session.requestPseudoTerminal("imagoConfig", 80, 48, 0, 0) && this.session.startShell();
                if (!pseudoTerminal) {
                    logger.error("Could not correctly prepare pseudo terminal for %s.", address);
                } else if (this.session.startShell()) {
                    result = ConnectResult.SUCCESS;
                    InputStream in = this.session.getInputStream();
                    this.iosc = new IOStreamConnector(in, (OutputStream)this.response);
                } else {
                    logger.error("Could not start shell for %s.", address);
                }
            } else {
                logger.info("Could not authenticate with %s.", address);
            }
        }
        catch (SshException sshe) {
            throw new LancomConnectException(result, (Throwable)sshe);
        }
        catch (ChannelOpenException coe) {
            throw new LancomConnectException(result, (Throwable)coe);
        }
        catch (SshIOException sshioe) {
            throw new LancomConnectException(result, (Throwable)sshioe);
        }
        catch (IOException ioe) {
            throw new LancomConnectException(result, (Throwable)ioe);
        }
        return result;
    }

    public void disconnect() {
        if (this.iosc != null) {
            this.iosc.close();
        }
        StreamUtils.close(this.response);
        if (this.session != null) {
            this.session.close();
        }
        if (this.client != null && this.client.isConnected()) {
            this.client.disconnect();
        }
    }

    public void sendAction(LancomConfigInstruction instruction, String parameter) throws LancomException {
        this.sendString(String.format("do %s%s %s\r\n", instruction.path, instruction.command, StringUtils.isNotBlank((String)parameter) ? parameter : ""));
        this.response.reset();
    }

    private boolean sendCommand(String template, LancomConfigInstruction instruction, String ... values) throws LancomException {
        boolean retValue = false;
        Object[] args = new Object[values.length + 2];
        args[0] = instruction.path;
        args[1] = instruction.command;
        for (int idx = 0; idx < values.length; ++idx) {
            args[idx + 2] = values[idx];
        }
        this.sendString(String.format(template, args));
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String response = this.response.toString();
        this.response.reset();
        if (instruction != LancomConfigInstruction.IP_ADDRESS || instruction != LancomConfigInstruction.SSH_PORT) {
            if (instruction.successMsg != null) {
                Matcher match = instruction.successMsg.matcher(response);
                if (match.find()) {
                    retValue = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Success with %s, response = %s", instruction.name(), response);
                    }
                } else {
                    logger.error("Could not set %s, response = %s", instruction.name(), response);
                }
            } else {
                retValue = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("Executed %s, response = %s", instruction.name(), response);
                }
            }
        }
        return retValue;
    }

    public boolean sendInstruction(LancomConfigInstruction instruction, String value) throws LancomException {
        return this.sendCommand("set %s%s %s\r\n", instruction, value);
    }

    public boolean sendSoftwareUpdateCommand(String softwareUpdatePackageUrl) throws LancomException {
        return this.sendCommand("%s%s %s\r\n", LancomConfigInstruction.LOAD_FIRMWARE, softwareUpdatePackageUrl);
    }

    public void completeConfig(LancomConfiguration config) throws LancomException {
        if (logger.isDebugEnabled()) {
            logger.debug("Completing config for %s.", config.getApId());
        }
        config.setWirelessChannel(this.receiveSetting(LancomConfigInstruction.WIRELESS_CHANNEL_GET));
        config.setGatewayAddress(this.receiveSetting(LancomConfigInstruction.GATEWAY_ADDRESS));
        config.setDnsAddress(this.receiveSetting(LancomConfigInstruction.DNS_ADDRESS));
        config.setControllerAddress(this.receiveSetting(LancomConfigInstruction.CONTROLLER_IP));
        config.set(LancomConfigOption.WIRELESS_E_PAPER_OPERATING, this.receiveSetting(LancomConfigInstruction.WIRELESS_E_PAPER_OPERATING));
    }

    public boolean initAndCompleteConfig(LancomConfiguration config, String newPassword, String oldPassword, boolean changePassword) throws LancomException {
        this.response.reset();
        boolean resultOk = true;
        if (changePassword) {
            resultOk = this.changePassword(newPassword, oldPassword);
        }
        this.turnOnWePaper();
        this.completeConfig(config);
        return resultOk;
    }

    public String receiveSetting(LancomConfigInstruction instruction) throws LancomException {
        this.sendString("ls " + instruction.path + "\r\n");
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String response = this.response.toString();
        this.response.reset();
        return LancomConfigParser.ParseSetting(response, instruction);
    }

    private void sendString(String command) throws LancomException {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending: [%s] in ASCII", command);
        }
        try {
            this.session.getOutputStream().write(command.getBytes(Charset.forName("US-ASCII")));
        }
        catch (SshIOException sshioe) {
            throw new LancomException("SSHIO error sending string: " + command, sshioe);
        }
        catch (IOException ioe) {
            throw new LancomException("IO error sending string: " + command, ioe);
        }
    }

    public void setLogin(String user, String password) {
        this.credentials = new SshCredentials(user, password);
    }

    public void sendIPAndSubnetMask(String ipAddress, String subnetMask) throws LancomException {
        this.sendString(String.format("set %s%s %s %s\r\n", LancomConfigInstruction.IP_ADDRESS.path, LancomConfigInstruction.IP_ADDRESS.command, ipAddress, subnetMask));
        try {
            Thread.sleep(400L);
            this.disconnect();
            this.connect(ipAddress, this.currentPort);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendIP(String address) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.IP_ADDRESS, address);
        try {
            Thread.sleep(400L);
            this.disconnect();
            this.currentAddress = address;
            this.connect(this.currentAddress, this.currentPort);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendWirelessChannel(String channel) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.WIRELESS_CHANNEL_SET, channel);
    }

    public void sendHostname(String hostname) throws LancomException {
        throw new NotImplementedException();
    }

    public void sendSubnetMask(String subnetMask) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.SUBNET_MASK, subnetMask);
    }

    public void sendGateway(String gateway) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.GATEWAY_ADDRESS, gateway);
    }

    public void sendDNSAddress(String dnsAddress) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.DNS_ADDRESS, dnsAddress);
    }

    public void sendSSHPort(String sshPort) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.SSH_PORT, sshPort);
        try {
            Thread.sleep(400L);
            this.disconnect();
            this.currentPort = Integer.parseInt(sshPort);
            this.connect(this.currentAddress, this.currentPort);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendWePaperPort(String WePaperPort) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.PORT, WePaperPort);
    }

    public void sendDeviceName(String name) throws LancomException {
        this.sendInstruction(LancomConfigInstruction.NAME, name);
    }

    public boolean turnOffWePaper() throws LancomException {
        return this.sendInstruction(LancomConfigInstruction.WIRELESS_E_PAPER_OPERATING, "Off");
    }

    public boolean turnOnWePaper() throws LancomException {
        return this.sendInstruction(LancomConfigInstruction.WIRELESS_E_PAPER_OPERATING, "Manual");
    }

    public boolean changePassword(String newPassword, String oldPassword) throws LancomException {
        if (StringUtils.isNotBlank((String)oldPassword)) {
            return this.sendCommand("%s%s \"%s\" \"%s\"\r\n", LancomConfigInstruction.PASSWORD, newPassword, oldPassword);
        }
        return this.sendCommand("%s%s \"%s\"\r\n", LancomConfigInstruction.PASSWORD, newPassword);
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    public void reboot() throws LancomException {
        this.sendAction(LancomConfigInstruction.REBOOT, "");
    }
}

