/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.integritycheck.gui;

import at.mrdevelopment.toolkit.integritycheck.AbstractResultHandler;
import at.mrdevelopment.toolkit.integritycheck.FileIntegrityResult;
import at.mrdevelopment.toolkit.integritycheck.gui.FileIntegrityResultTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class GuiResultHandler
extends AbstractResultHandler {
    private final FileIntegrityResultTableModel model;
    private final JTable table;
    private final JLabel status;
    private volatile boolean finished;

    public GuiResultHandler() {
        JFrame frame = new JFrame("Installation validation");
        frame.setLayout(new BorderLayout());
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (GuiResultHandler.this.finished) {
                    System.exit(GuiResultHandler.this.isFailed() ? 1 : 0);
                } else {
                    System.exit(2);
                }
            }
        });
        this.model = new FileIntegrityResultTableModel();
        this.table = new JTable(this.model);
        this.status = new JLabel("Running...", 0);
        this.status.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.status.setOpaque(true);
        this.status.setFont(this.status.getFont().deriveFont(1));
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEtchedBorder());
        statusPanel.add((Component)this.status, "Center");
        frame.add((Component)new JScrollPane(this.table), "Center");
        frame.add((Component)statusPanel, "Last");
        frame.setMinimumSize(new Dimension(100, 100));
        frame.setPreferredSize(new Dimension(500, 500));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    @Override
    public void handleResult(final FileIntegrityResult result) {
        super.handleResult(result);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiResultHandler.this.model.addResult(result);
                Rectangle rect = GuiResultHandler.this.table.getCellRect(GuiResultHandler.this.model.getRowCount() - 1, 0, true);
                GuiResultHandler.this.table.scrollRectToVisible(rect);
            }
        });
    }

    @Override
    public void finished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiResultHandler.this.finished = true;
                GuiResultHandler.this.status.setText("Validation " + (GuiResultHandler.this.isFailed() ? String.format("of %d file(s) failed", GuiResultHandler.this.getFailedFiles()) : "passed"));
                GuiResultHandler.this.status.setBackground(GuiResultHandler.this.isFailed() ? Color.RED : Color.GREEN);
                GuiResultHandler.this.status.setForeground(GuiResultHandler.this.isFailed() ? Color.WHITE : Color.BLACK);
            }
        });
    }
}

