/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.integritycheck.gui;

import at.mrdevelopment.toolkit.integritycheck.FileIntegrityResult;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class FileIntegrityResultTableModel
extends AbstractTableModel {
    private final List<FileIntegrityResult> results = new ArrayList<FileIntegrityResult>();

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FileIntegrityResult result = this.results.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return result.getFile().getPath();
            }
            case 1: {
                return result.getExpectedChecksum();
            }
            case 2: {
                return result.getActualChecksum();
            }
            case 3: {
                return result.getResult().toString();
            }
        }
        throw new AssertionError();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "File";
            }
            case 1: {
                return "Expected Checksum";
            }
            case 2: {
                return "Actual Checksum";
            }
            case 3: {
                return "Result";
            }
        }
        throw new AssertionError();
    }

    public void addResult(FileIntegrityResult result) {
        int index = this.results.size();
        this.results.add(result);
        this.fireTableRowsInserted(index, index);
    }
}

