/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.integritycheck;

import at.mrdevelopment.toolkit.integritycheck.FileIntegrityEntry;
import at.mrdevelopment.toolkit.integritycheck.Result;
import java.io.File;

public class FileIntegrityResult {
    private final File file;
    private final String expectedChecksum;
    private final String actualChecksum;
    private final Result result;

    public static FileIntegrityResult missing(File file, String checksum) {
        return new FileIntegrityResult(file, checksum, null, Result.FILE_MISSING);
    }

    public static FileIntegrityResult ioError(File file, String checksum) {
        return new FileIntegrityResult(file, checksum, null, Result.IO_ERROR);
    }

    public static FileIntegrityResult validate(FileIntegrityEntry fileIntegrityEntry, String checksum) {
        boolean valid = fileIntegrityEntry.isValid(checksum);
        return new FileIntegrityResult(fileIntegrityEntry.getFile(), checksum, fileIntegrityEntry.getChecksum(), valid ? Result.CHECKSUM_VALID : Result.CHECKSUM_INVALID);
    }

    private FileIntegrityResult(File file, String expectedChecksum, String actualChecksum, Result result) {
        this.file = file;
        this.expectedChecksum = expectedChecksum;
        this.actualChecksum = actualChecksum;
        this.result = result;
    }

    public File getFile() {
        return this.file;
    }

    public String getExpectedChecksum() {
        return this.expectedChecksum;
    }

    public String getActualChecksum() {
        return this.actualChecksum;
    }

    public Result getResult() {
        return this.result;
    }

    public String toString() {
        return String.format("%s on %s (expected %s, actual %s)", new Object[]{this.result, this.file.getPath(), this.expectedChecksum, this.actualChecksum});
    }
}

