/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.integritycheck;

import at.mrdevelopment.toolkit.integritycheck.FileIntegrityEntry;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class Crc32FileIntegrityEntry
implements FileIntegrityEntry {
    private static final CRC32 CRC32 = new CRC32();
    private final long checksum;
    private final File file;

    public Crc32FileIntegrityEntry(File file) throws IOException {
        this.checksum = Files.getChecksum((File)file, (Checksum)CRC32);
        this.file = file;
    }

    @Override
    public String getChecksum() {
        return String.format("CRC32=%08X", this.checksum);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public String toString() {
        return String.format("%s;%s", this.getChecksum(), this.file.getPath());
    }

    @Override
    public boolean isValid(String checksum) {
        return Objects.equal((Object)this.getChecksum(), (Object)checksum);
    }
}

