/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.integritycheck;

import at.mrdevelopment.toolkit.integritycheck.FileIntegrityResult;
import at.mrdevelopment.toolkit.integritycheck.ResultHandler;

public abstract class AbstractResultHandler
implements ResultHandler {
    private final long startTime = System.currentTimeMillis();
    private int validFiles = 0;
    private int failedFiles = 0;

    @Override
    public void handleResult(FileIntegrityResult result) {
        if (result.getResult().isError()) {
            ++this.failedFiles;
        } else {
            ++this.validFiles;
        }
    }

    @Override
    public boolean isFailed() {
        return this.failedFiles > 0;
    }

    public int getTotalFiles() {
        return this.validFiles + this.failedFiles;
    }

    public int getValidFiles() {
        return this.validFiles;
    }

    public int getFailedFiles() {
        return this.failedFiles;
    }

    public long getTimeElapsed() {
        return System.currentTimeMillis() - this.startTime;
    }
}

