/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.info;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.RequiredVersion;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class InfoXMLSerializer
implements XMLSerializer<Info> {
    private static final String SHORT_REVISION_STRING_PREFIX = "$Rev:";
    private static final String LONG_REVISION_STRING_PREFIX = "$Revision:";
    private static final String REVISION_STRING_SUFFIX = "$";
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Info parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        return this.parseInfoFromXML(root);
    }

    private Info parseInfoFromXML(Element element) throws SerializeException {
        String versionString = element.getAttribute("version");
        String buildString = element.getAttribute("build");
        int build = InfoXMLSerializer.parseBuild(buildString);
        Version version = new Version(Version.fromString(versionString), build);
        RequiredVersion requiredVersion = RequiredVersion.fromString(element.getAttribute("required-version"));
        return new Info(version, requiredVersion);
    }

    public static int parseBuild(String buildString) {
        buildString = StringUtils.remove((String)buildString, (String)SHORT_REVISION_STRING_PREFIX);
        buildString = StringUtils.remove((String)buildString, (String)LONG_REVISION_STRING_PREFIX);
        buildString = StringUtils.remove((String)buildString, (String)REVISION_STRING_SUFFIX);
        buildString = StringUtils.deleteWhitespace((String)buildString);
        try {
            return Integer.parseInt(buildString);
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }
}

