/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image.conversion;

import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class ImageToPCXConverter {
    public static void convertToPCX(BufferedImage image, OutputStream outputStream) throws IOException {
        outputStream.write(10);
        outputStream.write(5);
        outputStream.write(1);
        outputStream.write(1);
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] window = new byte[]{0, 0, 0, 0, (byte)(width - 1 & 0xFF), (byte)((width - 1) / 256), (byte)(height - 1 & 0xFF), (byte)((height - 1) / 256)};
        outputStream.write(window);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        byte[] colormap = new byte[48];
        colormap[3] = -1;
        colormap[4] = -1;
        colormap[5] = -1;
        outputStream.write(colormap);
        outputStream.write(0);
        outputStream.write(1);
        int bytesPerLine = width;
        if ((bytesPerLine & 1) == 1) {
            ++bytesPerLine;
        }
        outputStream.write((byte)(bytesPerLine & 0xFF));
        outputStream.write((byte)(bytesPerLine / 256));
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(0);
        byte[] filler = new byte[54];
        outputStream.write(filler);
        for (int row = 0; row < height; ++row) {
            ImageToPCXConverter.encode(image, bytesPerLine, row, outputStream);
        }
    }

    private static void encode(BufferedImage image, int bytesPerLine, int row, OutputStream outputStream) throws IOException {
        if (image.getType() != 12) {
            image = ImageUtils.toBlackWhite(image);
        }
        int scanlineLength = bytesPerLine;
        byte[] buffer = new byte[scanlineLength];
        byte[] bitflags = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        for (int i = 0; i < image.getWidth(); ++i) {
            int pixel = image.getRGB(i, row) & 0xFFFFFF;
            if (pixel <= 0x7FFFFF) continue;
            int n = i / 8;
            buffer[n] = (byte)(buffer[n] | bitflags[i & 7]);
        }
        int index = 0;
        while (index < scanlineLength) {
            int i;
            for (i = 0; i < 62 && index + i + 1 < scanlineLength && buffer[index + i] == buffer[index + i + 1]; ++i) {
            }
            if (i > 0) {
                outputStream.write(0xC0 | i + 1);
                outputStream.write(buffer[index]);
                index += i + 1;
                continue;
            }
            if ((buffer[index] & 0xC0) == 192) {
                outputStream.write(193);
            }
            outputStream.write(buffer[index++]);
        }
    }
}

