/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image.compression;

import at.mrdevelopment.toolkit.encoding.DC2Encoding;
import at.mrdevelopment.toolkit.encoding.DC3Encoding;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.encoding.NoEncoding;
import at.mrdevelopment.toolkit.encoding.SimpleBitRunLengthEncoding;
import at.mrdevelopment.toolkit.encoding.SimpleByteRunLengthEncoding;
import at.mrdevelopment.toolkit.encoding.SimpleByteRunLengthWithBWTEncoding;
import at.mrdevelopment.toolkit.encoding.SimpleThreeByteRunLengthEncoding;
import at.mrdevelopment.toolkit.image.BlackWhiteColorMapping;
import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.EncodedImage;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import at.mrdevelopment.toolkit.image.RawImageType;
import at.mrdevelopment.toolkit.image.RedWhiteColorMapping;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import org.junit.Test;

public class ImageCompressionTest {
    private static final String IMAGE_DIRECTORY = "data/ImageCompressionTest";
    private static final ColorMapping BLACK_WHITE = new BlackWhiteColorMapping();
    private static final ColorMapping RED_WHITE = new RedWhiteColorMapping();

    @Test
    public void testEncodings() throws IOException {
        List<DataEncoding> encodings = Arrays.asList(new DC2Encoding(), new DC3Encoding(), new NoEncoding(), new SimpleBitRunLengthEncoding(), new SimpleByteRunLengthEncoding(), new SimpleByteRunLengthWithBWTEncoding(), new SimpleThreeByteRunLengthEncoding());
        for (DataEncoding encoding : encodings) {
            this.testEncodingAndDecoding(encoding, RawImageType.TYPE_BINARY, BLACK_WHITE);
            this.testEncodingAndDecoding(encoding, RawImageType.LINED_UP_IMAGES, BLACK_WHITE, RED_WHITE);
        }
    }

    private void testEncodingAndDecoding(DataEncoding encoding, RawImageType rawImageType, ColorMapping ... colorMappings) throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(IMAGE_DIRECTORY);
        File file = new File(resource.getFile());
        for (File image : file.listFiles()) {
            BufferedImage input = ImageIO.read(image);
            RawImage rawImage = RawImageFactory.newImage(input, rawImageType, colorMappings);
            EncodedImage encodedImage = encoding.encode(rawImage);
            RawImage decodedImage = encoding.decode(encodedImage);
            ImageCompressionTest.assertImageEquals(rawImage, decodedImage);
        }
    }

    private static void assertImageEquals(RawImage expected, RawImage actual) {
        if (!Arrays.equals(expected.getBytes(), actual.getBytes())) {
            throw new AssertionError();
        }
    }
}

