/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image.compression;

import at.mrdevelopment.toolkit.encoding.DC3Encoding;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.image.BlackWhiteColorMapping;
import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.EncodedImage;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import at.mrdevelopment.toolkit.image.RawImageType;
import at.mrdevelopment.toolkit.image.RedWhiteColorMapping;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.junit.Assert;
import org.junit.Test;

public class BadImageCompressionTest {
    private static final String IMAGE_DIRECTORY = "data/BadImageCompressionTest";
    private static final ColorMapping BLACK_WHITE = new BlackWhiteColorMapping();
    private static final ColorMapping RED_WHITE = new RedWhiteColorMapping();

    @Test
    public void testDC3Encoding() throws IOException {
        this.testEncodingAndDecoding(new DC3Encoding());
    }

    private void testEncodingAndDecoding(DataEncoding encoding) throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(IMAGE_DIRECTORY);
        File file = new File(resource.getFile());
        for (File image : file.listFiles()) {
            BufferedImage input = ImageIO.read(image);
            RawImage rawImage = RawImageFactory.newImage(input, RawImageType.LINED_UP_IMAGES, BLACK_WHITE, RED_WHITE);
            EncodedImage encodedImage = encoding.encode(rawImage);
            Assert.assertTrue((encodedImage.getEncodedBytes().length > rawImage.getBytes().length ? 1 : 0) != 0);
        }
    }
}

