/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.StreamUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class SVG {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSVGToPNG(File svgFile) throws FileNotFoundException, TranscoderException {
        TranscoderInput inputSVGImage = new TranscoderInput(svgFile.toURI().toString());
        String pngFileNameString = FilenameUtils.removeExtension((String)svgFile.getAbsolutePath());
        String pathOut = pngFileNameString + ".png";
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(pathOut);
            TranscoderOutput pngImage = new TranscoderOutput((OutputStream)ostream);
            PNGTranscoder transcoder = new PNGTranscoder();
            transcoder.transcode(inputSVGImage, pngImage);
        }
        catch (Throwable throwable) {
            StreamUtils.close(ostream);
            throw throwable;
        }
        StreamUtils.close(ostream);
    }

    public static BufferedImage SVGToBufferedImage(InputStream inputStream) throws IOException {
        final BufferedImage[] imagePointer = new BufferedImage[1];
        String css = "svg {shape-rendering: geometricPrecision;text-rendering:  geometricPrecision;color-rendering: optimizeQuality;image-rendering: optimizeQuality;}";
        File cssFile = File.createTempFile("batik-default-override-", ".css");
        FileUtils.writeStringToFile((File)cssFile, (String)css);
        TranscodingHints transcoderHints = new TranscodingHints();
        transcoderHints.put((Object)ImageTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
        transcoderHints.put((Object)ImageTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        transcoderHints.put((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI, (Object)cssFile.toURI().toString());
        try {
            TranscoderInput input = new TranscoderInput(inputStream);
            ImageTranscoder transcoder = new ImageTranscoder(){

                public BufferedImage createImage(int w, int h) {
                    return new BufferedImage(w, h, 2);
                }

                public void writeImage(BufferedImage image, TranscoderOutput out) throws TranscoderException {
                    imagePointer[0] = image;
                }
            };
            transcoder.setTranscodingHints(transcoderHints);
            transcoder.transcode(input, null);
        }
        catch (TranscoderException exc) {
            throw new IOException(exc);
        }
        finally {
            cssFile.delete();
        }
        return imagePointer[0];
    }
}

