/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;

public class RoundedRectangle {
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_RIGHT = 4;
    public static final int BOTTOM_LEFT = 8;
    public static final int ALL = 15;
    private static final int DEFAULT_SEGMENT_COUNT = 25;
    private float cornerRadius;
    private int segmentCount;
    private int cornerFlags;
    private float x;
    private float y;
    private float width;
    private float height;
    private float[] points;
    private List<Integer> xPoints;
    private List<Integer> yPoints;
    private Rectangle innerRectangle;

    public RoundedRectangle(float x, float y, float width, float height, float cornerRadius) {
        this(x, y, width, height, cornerRadius, 25);
    }

    public RoundedRectangle(float x, float y, float width, float height, float cornerRadius, int cornerFlags) {
        this(x, y, width, height, cornerRadius, cornerFlags, 25);
    }

    public RoundedRectangle(float x, float y, float width, float height, float cornerRadius, int cornerFlags, int segmentCount) {
        if (cornerRadius < 0.0f) {
            throw new IllegalArgumentException("corner radius must be >= 0");
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.cornerRadius = cornerRadius;
        this.segmentCount = segmentCount;
        this.cornerFlags = cornerFlags;
        this.xPoints = new ArrayList<Integer>();
        this.yPoints = new ArrayList<Integer>();
        this.createPoints();
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public int getCornerFlags() {
        return this.cornerFlags;
    }

    public float getCornerRadius() {
        return this.cornerRadius;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getY() {
        return this.y;
    }

    public float getX() {
        return this.x;
    }

    protected void createPoints() {
        float useWidth = this.width - 1.0f;
        float useHeight = this.height - 1.0f;
        if (this.cornerRadius == 0.0f) {
            this.points = new float[8];
            this.points[0] = this.x;
            this.points[1] = this.y;
            this.points[2] = this.x + useWidth;
            this.points[3] = this.y;
            this.points[4] = this.x + useWidth;
            this.points[5] = this.y + useHeight;
            this.points[6] = this.x;
            this.points[7] = this.y + useHeight;
            this.addRoundedPoint(this.x, this.y);
            this.addRoundedPoint(this.x + useWidth, this.y);
            this.addRoundedPoint(this.x + useWidth, this.y + useHeight);
            this.addRoundedPoint(this.x, this.y + useHeight);
        } else {
            float doubleRadius = this.cornerRadius * 2.0f;
            if (doubleRadius > useWidth) {
                doubleRadius = useWidth;
                this.cornerRadius = doubleRadius / 2.0f;
            }
            if (doubleRadius > useHeight) {
                doubleRadius = useHeight;
                this.cornerRadius = doubleRadius / 2.0f;
            }
            ArrayList<Float> tempPoints = new ArrayList<Float>();
            this.xPoints.clear();
            this.yPoints.clear();
            float tlx = this.x;
            float tly = this.y;
            float trx = this.x + useWidth;
            float topRightY = this.y;
            float brx = this.x + useWidth;
            float bry = this.y + useHeight;
            float blx = this.x;
            float bly = this.y + useHeight;
            if ((this.cornerFlags & 1) != 0) {
                List<Float> topLeftPoints = this.createPoints(this.segmentCount, this.cornerRadius, this.x + this.cornerRadius, this.y + this.cornerRadius, 180.0f, 270.0f);
                tlx = topLeftPoints.get(topLeftPoints.size() / 2 - 2).floatValue();
                tly = topLeftPoints.get(topLeftPoints.size() / 2 - 1).floatValue();
                tempPoints.addAll(topLeftPoints);
            } else {
                this.addRoundedPoint(this.x, this.y);
                tempPoints.add(new Float(this.x));
                tempPoints.add(new Float(this.y));
            }
            if ((this.cornerFlags & 2) != 0) {
                List<Float> topRightPoints = this.createPoints(this.segmentCount, this.cornerRadius, this.x + useWidth - this.cornerRadius, this.y + this.cornerRadius, 270.0f, 360.0f);
                trx = topRightPoints.get(topRightPoints.size() / 2 - 2).floatValue();
                topRightY = topRightPoints.get(topRightPoints.size() / 2 - 1).floatValue();
                tempPoints.addAll(topRightPoints);
            } else {
                this.addRoundedPoint(this.x + useWidth, this.y);
                tempPoints.add(new Float(this.x + useWidth));
                tempPoints.add(new Float(this.y));
            }
            if ((this.cornerFlags & 4) != 0) {
                List<Float> bottomRightPoints = this.createPoints(this.segmentCount, this.cornerRadius, this.x + useWidth - this.cornerRadius, this.y + useHeight - this.cornerRadius, 0.0f, 90.0f);
                brx = bottomRightPoints.get(bottomRightPoints.size() / 2 - 2).floatValue();
                bry = bottomRightPoints.get(bottomRightPoints.size() / 2 - 1).floatValue();
                tempPoints.addAll(bottomRightPoints);
            } else {
                this.addRoundedPoint(this.x + useWidth, this.y + useHeight);
                tempPoints.add(new Float(this.x + useWidth));
                tempPoints.add(new Float(this.y + useHeight));
            }
            if ((this.cornerFlags & 8) != 0) {
                List<Float> bottomLeftPoints = this.createPoints(this.segmentCount, this.cornerRadius, this.x + this.cornerRadius, this.y + useHeight - this.cornerRadius, 90.0f, 180.0f);
                blx = bottomLeftPoints.get(bottomLeftPoints.size() / 2 - 2).floatValue();
                bly = bottomLeftPoints.get(bottomLeftPoints.size() / 2 - 1).floatValue();
                tempPoints.addAll(bottomLeftPoints);
            } else {
                this.addRoundedPoint(this.x, this.y + useHeight);
                tempPoints.add(new Float(this.x));
                tempPoints.add(new Float(this.y + useHeight));
            }
            this.points = new float[tempPoints.size()];
            for (int i = 0; i < tempPoints.size(); ++i) {
                this.points[i] = ((Float)tempPoints.get(i)).floatValue();
            }
            int innerX = (int)Math.max(tlx, blx);
            int innerY = (int)Math.max(tly, topRightY);
            int innerBottomRightX = (int)Math.min(trx, brx);
            int innerBottomRightY = (int)Math.min(bly, bry);
            this.innerRectangle = new Rectangle(innerX, innerY, innerBottomRightX - innerX, innerBottomRightY - innerY);
        }
    }

    private List<Float> createPoints(int numberOfSegments, float radius, float cx, float cy, float start, float end) {
        ArrayList<Float> tempPoints = new ArrayList<Float>();
        int step = 360 / numberOfSegments;
        for (float a = start; a <= end + (float)step; a += (float)step) {
            float ang = a;
            if (ang > end) {
                ang = end;
            }
            float x = (float)((double)cx + Math.cos(Math.toRadians(ang)) * (double)radius);
            float y = (float)((double)cy + Math.sin(Math.toRadians(ang)) * (double)radius);
            this.addRoundedPoint(x, y);
            tempPoints.add(new Float(x));
            tempPoints.add(new Float(y));
        }
        return tempPoints;
    }

    private void addRoundedPoint(float x, float y) {
        this.xPoints.add(Math.round(x));
        this.yPoints.add(Math.round(y));
    }

    public Rectangle getInnerRectangle() {
        return this.innerRectangle;
    }

    public Shape getShape() {
        int[] xPoints = new int[this.points.length / 2];
        int[] yPoints = new int[this.points.length / 2];
        for (int i = 0; i < this.points.length; i += 2) {
            xPoints[i / 2] = Math.round(this.points[i]);
            yPoints[i / 2] = Math.round(this.points[i + 1]);
        }
        return new Polygon(xPoints, yPoints, xPoints.length);
    }

    public void setHeightBasedOnInnerRectangle(int newHeight) {
        double factor;
        int newTotalHeight;
        if (newHeight < this.innerRectangle.width && (float)((newTotalHeight = (int)Math.round((double)newHeight + 2.0 * (factor = Math.sqrt(Math.pow(2.0f * this.cornerRadius, 2.0) + Math.pow(2.0f * this.cornerRadius, 2.0)) / 2.0 - (double)this.cornerRadius))) - 1) < 2.0f * this.cornerRadius) {
            this.cornerRadius = (float)(newHeight - 1) / 2.58f;
            this.height = (float)((double)newHeight + 2.0 * (Math.sqrt(Math.pow(2.0f * this.cornerRadius, 2.0) + Math.pow(2.0f * this.cornerRadius, 2.0)) / 2.0 - (double)this.cornerRadius));
        }
        this.createPoints();
    }

    public void setYPos(int newPosY) {
        this.y = newPosY;
        this.createPoints();
    }

    public List<Integer> getXPoints() {
        return this.xPoints;
    }

    public List<Integer> getYPoints() {
        return this.yPoints;
    }

    public float[] getPoints() {
        return this.points;
    }

    public void setXPos(int newPosX) {
        this.x = newPosX;
        this.createPoints();
    }
}

