/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.ColorResolver;
import at.mrdevelopment.toolkit.image.DirectColorResolver;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.IndexedColorResolver;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageImpl;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;

public enum RawImageType {
    TYPE_BINARY{

        @Override
        public RawImage fromBufferedImage(BufferedImage source, ColorMapping[] colorMappings) {
            boolean isWhite = true;
            int width = source.getWidth();
            int height = source.getHeight();
            BufferedImage image = ImageUtils.toBlackWhite(source);
            WritableRaster raster = image.getRaster();
            RawImageImpl target = new RawImageImpl(width, height, this, colorMappings);
            byte[] data = target.getBytes();
            int[] color = new int[3];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, color);
                    int value = colorMappings[0].getValue(color);
                    if (value > 0) {
                        int currentBitPosition = y * width + x;
                        int index = currentBitPosition / 8;
                        int shift = 7 - currentBitPosition % 8;
                        data[index] = (byte)(data[index] | 1 << shift);
                    }
                    if (value == 0) continue;
                    isWhite = false;
                }
            }
            target.getRawImageProperties().setWhite(isWhite);
            return target;
        }

        @Override
        public BufferedImage toBufferedImage(RawImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            byte[] data = source.getBytes();
            BufferedImage target = new BufferedImage(width, height, 1);
            WritableRaster raster = target.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int currentBitPosition = y * width + x;
                    int index = currentBitPosition / 8;
                    int shift = 7 - currentBitPosition % 8;
                    int value = data[index] >> shift & 1;
                    int[] color = colorMappings[0].getColor(value);
                    raster.setPixel(x, y, color);
                }
            }
            return target;
        }

        @Override
        public int getImageSize(int width, int height) {
            return width * height / 8;
        }
    }
    ,
    TYPE_2BIT{

        @Override
        public RawImage fromBufferedImage(BufferedImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            WritableRaster raster = source.getRaster();
            RawImageImpl target = new RawImageImpl(width, height, this, colorMappings);
            byte[] data = target.getBytes();
            int[] color = new int[4];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, color);
                    int value = colorMappings[0].getValue(color);
                    int currentBitPosition = y * width + x;
                    int index = currentBitPosition / 4;
                    int shift = 6 - currentBitPosition % 4 * 2;
                    data[index] = (byte)(data[index] | (byte)(value << shift));
                }
            }
            return target;
        }

        @Override
        public BufferedImage toBufferedImage(RawImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            byte[] data = source.getBytes();
            BufferedImage target = new BufferedImage(width, height, 1);
            WritableRaster raster = target.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int currentBitPosition = y * width + x;
                    int index = currentBitPosition / 4;
                    int shift = 6 - currentBitPosition % 4 * 2;
                    int value = (byte)(data[index] >> shift) & 3;
                    int[] color = colorMappings[0].getColor(value);
                    raster.setPixel(x, y, color);
                }
            }
            return target;
        }

        @Override
        public int getImageSize(int width, int height) {
            return width * height / 4;
        }
    }
    ,
    LINED_UP_IMAGES{

        @Override
        public RawImage fromBufferedImage(BufferedImage source, ColorMapping[] colorMappings) {
            boolean isWhite = true;
            int width = source.getWidth();
            int height = source.getHeight();
            WritableRaster imageRaster = source.getRaster();
            RawImageImpl target = new RawImageImpl(width, height, this, colorMappings);
            ColorModel colorModel = source.getColorModel();
            byte[] data = target.getBytes();
            int offset = width * height / 8;
            ColorResolver colorResolver = colorModel instanceof ComponentColorModel ? new DirectColorResolver() : new IndexedColorResolver();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int[] color = colorResolver.getColor(colorModel, imageRaster, x, y);
                    int value1 = colorMappings[0].getValue(color);
                    int value2 = colorMappings[1].getValue(color);
                    int currentBitPosition = y * width + x;
                    int shift = 7 - currentBitPosition % 8;
                    int index = currentBitPosition / 8;
                    if (value1 != 0) {
                        data[index] = (byte)(data[index] | (byte)(1 << shift));
                    }
                    if (value2 == 0) continue;
                    data[index += offset] = (byte)(data[index] | (byte)(1 << shift));
                    isWhite = false;
                }
            }
            target.getRawImageProperties().setWhite(isWhite);
            return target;
        }

        @Override
        public BufferedImage toBufferedImage(RawImage source, ColorMapping[] colorMappings) {
            int width = source.getWidth();
            int height = source.getHeight();
            byte[] data = source.getBytes();
            BufferedImage blackWhiteImage = new BufferedImage(width, height, 2);
            BufferedImage colorWhiteImage = new BufferedImage(width, height, 2);
            int offset = width * height / 8;
            this.writeBufferedImagePart(blackWhiteImage, 0, data, colorMappings[0]);
            this.writeBufferedImagePart(colorWhiteImage, offset, data, colorMappings[1]);
            BufferedImage target = new BufferedImage(width, height, 2);
            ImageUtils.fill(target, Color.WHITE);
            ImageUtils.overlay(target, blackWhiteImage);
            ImageUtils.overlay(target, colorWhiteImage);
            return target;
        }

        private void writeBufferedImagePart(BufferedImage image, int offset, byte[] data, ColorMapping colorMapping) {
            int width = image.getWidth();
            int height = image.getHeight();
            WritableRaster raster = image.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int currentBitPosition = y * width + x;
                    int index = offset + currentBitPosition / 8;
                    int shift = 7 - currentBitPosition % 8;
                    int value = (byte)(data[index] >> shift) & 1;
                    int[] color = colorMapping.getColor(value);
                    raster.setPixel(x, y, color);
                }
            }
        }

        @Override
        public int getImageSize(int width, int height) {
            return width * height / 4;
        }
    };


    public abstract RawImage fromBufferedImage(BufferedImage var1, ColorMapping[] var2);

    public abstract BufferedImage toBufferedImage(RawImage var1, ColorMapping[] var2);

    public abstract int getImageSize(int var1, int var2);
}

