/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageProperties;
import at.mrdevelopment.toolkit.image.RawImageType;
import java.awt.image.BufferedImage;

public class RawImageImpl
implements RawImage {
    private final RawImageType type;
    private final ColorMapping[] colorMappings;
    private final int width;
    private final int height;
    private final byte[] image;
    private final RawImageProperties rawImageProperties;

    RawImageImpl(int width, int height, RawImageType type, RawImageProperties rawImageProperties, ColorMapping[] colorMappings) {
        this.type = type;
        this.colorMappings = colorMappings;
        this.width = width;
        this.height = height;
        this.image = new byte[type.getImageSize(width, height)];
        this.rawImageProperties = rawImageProperties;
    }

    RawImageImpl(int width, int height, RawImageType type, ColorMapping[] colorMappings) {
        this(width, height, type, new RawImageProperties(), colorMappings);
    }

    RawImageImpl(int width, int height, byte[] image, RawImageType type, ColorMapping[] colorMappings) {
        this(width, height, image, type, new RawImageProperties(), colorMappings);
    }

    RawImageImpl(int width, int height, byte[] image, RawImageType type, RawImageProperties rawImageProperties, ColorMapping[] colorMappings) {
        this(width, height, type, rawImageProperties, colorMappings);
        System.arraycopy(image, 0, this.image, 0, this.getSize());
    }

    @Override
    public RawImageType getType() {
        return this.type;
    }

    @Override
    public ColorMapping[] getColorMappings() {
        return this.colorMappings;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public byte[] getBytes() {
        return this.image;
    }

    @Override
    public int getSize() {
        return this.image.length;
    }

    @Override
    public BufferedImage toBufferedImage() {
        return this.type.toBufferedImage(this, this.colorMappings);
    }

    @Override
    public RawImageProperties getRawImageProperties() {
        return this.rawImageProperties;
    }

    public void loadFromHexdump(String hexdump) {
        for (int index = 0; index < this.image.length; ++index) {
            this.image[index] = Integer.decode("0x" + hexdump.charAt(index * 2) + hexdump.charAt(index * 2 + 1)).byteValue();
        }
    }

    public String toHexdump() {
        StringBuffer buffer = new StringBuffer(this.image.length * 2);
        for (int index = 0; index < this.image.length; ++index) {
            byte b = this.image[index];
            buffer.append(String.format("%02X", b));
        }
        return buffer.toString();
    }
}

