/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.junit.Test;

public class ImageUtilsTest {
    @Test
    public void testRotate0() throws IOException {
        BufferedImage input = ImageIO.read(new File("data/ImageUtilsTest/testRotateInput.png"));
        BufferedImage expected = ImageIO.read(new File("data/ImageUtilsTest/testRotate0.png"));
        BufferedImage actual = ImageUtils.rotate(input, 0);
        ImageIO.write((RenderedImage)actual, "png", new File("data/ImageUtilsTest/testRotateOutput0.png"));
        ImageUtilsTest.assertImageEquals(expected, actual);
    }

    @Test
    public void testRotate90() throws IOException {
        BufferedImage input = ImageIO.read(new File("data/ImageUtilsTest/testRotateInput.png"));
        BufferedImage expected = ImageIO.read(new File("data/ImageUtilsTest/testRotate90.png"));
        BufferedImage actual = ImageUtils.rotate(input, 90);
        ImageIO.write((RenderedImage)actual, "png", new File("data/ImageUtilsTest/testRotateOutput90.png"));
        ImageUtilsTest.assertImageEquals(expected, actual);
    }

    @Test
    public void testRotate180() throws IOException {
        BufferedImage input = ImageIO.read(new File("data/ImageUtilsTest/testRotateInput.png"));
        BufferedImage expected = ImageIO.read(new File("data/ImageUtilsTest/testRotate180.png"));
        BufferedImage actual = ImageUtils.rotate(input, 180);
        ImageIO.write((RenderedImage)actual, "png", new File("data/ImageUtilsTest/testRotateOutput180.png"));
        ImageUtilsTest.assertImageEquals(expected, actual);
    }

    @Test
    public void testRotate270() throws IOException {
        BufferedImage input = ImageIO.read(new File("data/ImageUtilsTest/testRotateInput.png"));
        BufferedImage expected = ImageIO.read(new File("data/ImageUtilsTest/testRotate270.png"));
        BufferedImage actual = ImageUtils.rotate(input, 270);
        ImageIO.write((RenderedImage)actual, "png", new File("data/ImageUtilsTest/testRotateOutput270.png"));
        ImageUtilsTest.assertImageEquals(expected, actual);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRotateUnsupported() throws IOException {
        BufferedImage input = ImageIO.read(new File("data/ImageUtilsTest/testRotateInput.png"));
        ImageUtils.rotate(input, 45);
    }

    @Test
    public void testRotatePerformance() throws IOException {
        int iterations = 80;
        BufferedImage image = ImageIO.read(new File("data/ImageUtilsTest/testRotateInput.png"));
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            image = ImageUtils.rotate(image, 90);
        }
        long finished = System.currentTimeMillis();
        System.out.println("Average time per iteration in milliseconds: " + (double)(finished - start) / (double)iterations);
        ImageUtilsTest.assertImageEquals(image, image);
    }

    private static void assertImageEquals(BufferedImage expected, BufferedImage actual) {
        if (expected.getWidth() != actual.getWidth() || expected.getHeight() != actual.getHeight()) {
            throw new AssertionError();
        }
        for (int x = 0; x < expected.getWidth(); ++x) {
            for (int y = 0; y < expected.getHeight(); ++y) {
                if (expected.getRGB(x, y) != actual.getRGB(x, y)) {
                    throw new AssertionError();
                }
            }
        }
    }
}

