/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.Pair;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.image.DitheringThreshold;
import at.mrdevelopment.toolkit.image.HorizontalAlignment;
import at.mrdevelopment.toolkit.image.RoundedRectangle;
import at.mrdevelopment.toolkit.image.SVG;
import at.mrdevelopment.toolkit.image.ShadowProperties;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.jhlabs.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;

public class ImageUtils {
    static ESLLogger logger = ESLLogger.getLogger(ImageUtils.class);
    private static final int MAXVAL = 0xFFFFFF;
    private static final int MINVAL = 0;
    private static final int WHITE = 1;
    private static final Stroke DEFAULT_DASHED_STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f}, 10.0f);

    private ImageUtils() {
    }

    public static BufferedImage byteMatrixToImage(ByteMatrix byteMatrix) {
        BufferedImage image = new BufferedImage(byteMatrix.getWidth(), byteMatrix.getHeight(), 12);
        int x = 0;
        for (byte[] matrixline : byteMatrix.getArray()) {
            int y = 0;
            for (byte elem : matrixline) {
                image.setRGB(y, x, elem == 1 ? 0 : 0xFFFFFF);
                ++y;
            }
            ++x;
        }
        return image;
    }

    public static BufferedImage resize(BufferedImage originalImage, int requestedWidth, int requestedHeight) {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        return ImageUtils.resize(originalImage, requestedWidth, requestedHeight, originalImage.getType());
    }

    public static BufferedImage resize(BufferedImage originalImage, int requestedWidth, int requestedHeight, int imageType) {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        BufferedImage resizedImage = new BufferedImage(requestedWidth, requestedHeight, imageType);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.drawImage(originalImage, 0, 0, requestedWidth, requestedHeight, 0, 0, width, height, null);
        graphics.dispose();
        return resizedImage;
    }

    public static BufferedImage scale(BufferedImage originalImage, int scale, int imageType) throws IllegalArgumentException {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        if (scale < 1) {
            throw new IllegalArgumentException("Scale must be at least 1");
        }
        return ImageUtils.resize(originalImage, originalImage.getWidth() * scale, originalImage.getHeight() * scale);
    }

    public static BufferedImage scale(BufferedImage originalImage, int scale) throws IllegalArgumentException {
        if (originalImage == null) {
            throw new IllegalArgumentException("Image was null");
        }
        return ImageUtils.scale(originalImage, scale, originalImage.getType());
    }

    public static BufferedImage clip(BufferedImage originalImage, Rectangle rectangle) {
        if (originalImage == null) {
            return null;
        }
        int imageType = 1;
        if (originalImage.getType() != 0) {
            imageType = originalImage.getType();
        }
        return ImageUtils.clip(originalImage, rectangle, imageType);
    }

    public static BufferedImage clip(BufferedImage originalImage, Rectangle rectangle, int imageType) {
        if (rectangle == null || originalImage == null) {
            return null;
        }
        int width = (int)rectangle.getWidth();
        int height = (int)rectangle.getHeight();
        int xsrc = (int)rectangle.getMinX();
        int ysrc = (int)rectangle.getMinY();
        BufferedImage clippedImage = new BufferedImage(width, height, imageType);
        Graphics2D graphics = clippedImage.createGraphics();
        graphics.drawImage(originalImage, 0, 0, width, height, xsrc, ysrc, xsrc + width, ysrc + height, null);
        graphics.dispose();
        return clippedImage;
    }

    public static BufferedImage clipToUsedSize(BufferedImage image, Rectangle contentBounds, int maxWidth, int maxHeight) {
        if (contentBounds != null) {
            int width = contentBounds.width > maxWidth ? maxWidth : contentBounds.width;
            int height = contentBounds.height > maxHeight ? maxHeight : contentBounds.height;
            return ImageUtils.clip(image, new Rectangle(contentBounds.x, contentBounds.y, width, height));
        }
        return image;
    }

    public static void overlay(BufferedImage background, BufferedImage foreground) throws IllegalArgumentException {
        ImageUtils.overlay(background, foreground, 0, 0, background.getWidth(), background.getHeight(), 0, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    public static void overlayAt(BufferedImage background, BufferedImage foreground, int posX, int posY) throws IllegalArgumentException {
        if (background == null || background.getWidth() <= 0 || background.getHeight() <= 0 || foreground == null || foreground.getWidth() <= 0 || foreground.getHeight() <= 0) {
            throw new IllegalArgumentException("Foreground and background image cannot be empty.");
        }
        if (background.getWidth() < posX + foreground.getWidth() || background.getHeight() < posY + foreground.getHeight()) {
            throw new IllegalArgumentException("Background image is too small");
        }
        Graphics2D graphics = background.createGraphics();
        graphics.drawImage((Image)foreground, posX, posY, null);
    }

    public static void overlayTopLeft(BufferedImage background, BufferedImage foreground) throws IllegalArgumentException {
        ImageUtils.overlay(background, foreground, 0, 0, background.getWidth(), background.getHeight(), 0, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    public static Point overlay(BufferedImage background, Rectangle clippingRegion, BufferedImage foreground, Rectangle alignmentBounds, int posX, int posY, int width, int height, int rotation, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) throws IllegalArgumentException {
        if (background.getWidth() < posX + width || background.getHeight() < posY + height) {
            throw new IllegalArgumentException("Background image is too small");
        }
        if (width < alignmentBounds.width || height < alignmentBounds.height) {
            throw new IllegalArgumentException("Drawing area is too small");
        }
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            posX += ImageUtils.getCenteringIndex(width, alignmentBounds.width);
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            posX = posX + width - alignmentBounds.width;
        }
        if (verticalAlignment == VerticalAlignment.CENTER) {
            posY += ImageUtils.getCenteringIndex(height, alignmentBounds.height);
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            posY = posY + height - alignmentBounds.height;
        }
        Graphics2D graphics = background.createGraphics();
        if (clippingRegion != null) {
            graphics.setClip(clippingRegion);
        }
        graphics.drawImage((Image)foreground, posX, posY, null);
        return new Point(posX, posY);
    }

    public static Point overlay(BufferedImage background, Rectangle clippingRegion, BufferedImage foreground, int posX, int posY, int width, int height, int rotation, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) throws IllegalArgumentException {
        return ImageUtils.overlay(background, clippingRegion, foreground, new Rectangle(foreground.getWidth(), foreground.getHeight()), posX, posY, width, height, rotation, horizontalAlignment, verticalAlignment);
    }

    public static Point overlay(BufferedImage background, BufferedImage foreground, int posX, int posY, int width, int height, int rotation, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) throws IllegalArgumentException {
        return ImageUtils.overlay(background, null, foreground, new Rectangle(foreground.getWidth(), foreground.getHeight()), posX, posY, width, height, rotation, horizontalAlignment, verticalAlignment);
    }

    public static int getCenteringIndex(int framePx, int contentPx) {
        return (int)Math.floor((double)(framePx - contentPx) / 2.0);
    }

    public static void fill(BufferedImage image, Paint color) {
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(color);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.dispose();
    }

    public static BufferedImage createImage(int width, int height, int type, Paint color) {
        BufferedImage image = new BufferedImage(width, height, type);
        ImageUtils.fill(image, color);
        return image;
    }

    public static BufferedImage createImage(int width, int height, int type) {
        return new BufferedImage(width, height, type);
    }

    public static BufferedImage flip(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-image.getWidth(null), -image.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    public static BufferedImage toBlackWhite(BufferedImage image) {
        BufferedImage blackAndWhiteImage = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        Graphics2D graphics = blackAndWhiteImage.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        return blackAndWhiteImage;
    }

    public static BufferedImage toRGB(BufferedImage image) {
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        Graphics2D graphics = rgbImage.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        return rgbImage;
    }

    public static void drawBorder(BufferedImage fieldImage, RoundedRectangle rectangle, Paint borderColor, Stroke borderStroke) {
        ImageUtils.drawBorder(fieldImage, 0, 0, rectangle, borderColor, borderStroke);
    }

    public static void drawBorder(BufferedImage fieldImage, int x, int y, RoundedRectangle rectangle, Paint borderColor, Stroke borderStroke) {
        Graphics2D graphics = fieldImage.createGraphics();
        ImageUtils.drawBorder(graphics, x, y, rectangle, borderColor, borderStroke);
        graphics.dispose();
    }

    public static void drawBorder(Graphics2D graphics, int x, int y, RoundedRectangle rectangle, Paint borderColor, Stroke borderStroke) {
        graphics.setPaint(borderColor);
        graphics.setStroke(borderStroke);
        float width = rectangle.getWidth();
        float height = rectangle.getHeight();
        graphics.draw(new RoundedRectangle(x, y, width, height, rectangle.getCornerRadius(), rectangle.getCornerFlags()).getShape());
    }

    public static void drawBorder(BufferedImage image, Paint color, BasicStroke stroke, boolean rounded) {
        int width = image.getWidth();
        int height = image.getHeight();
        int thickness = Math.round(stroke.getLineWidth());
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(color);
        for (int i = 0; i < thickness; ++i) {
            if (rounded) {
                graphics.drawRoundRect(i, i, width - i - i - 1, height - i - i - 1, thickness, thickness);
                continue;
            }
            graphics.drawRect(i, i, width - i - i - 1, height - i - i - 1);
        }
    }

    public static void drawBorder(BufferedImage image, int posX, int posY, int width, int height, Paint color, Stroke stroke) {
        ImageUtils.drawBorder(image, (Shape)new Rectangle(posX, posY, width, height), color, stroke);
    }

    public static void drawBorder(BufferedImage image, Shape shape, Paint color, Stroke stroke) {
        Graphics2D graphics = image.createGraphics();
        ImageUtils.drawBorder(graphics, shape, color, stroke);
        graphics.dispose();
    }

    public static void drawBorder(Graphics2D graphics, Shape shape, Paint color, Stroke stroke) {
        graphics.setPaint(color);
        graphics.setStroke(stroke);
        graphics.draw(shape);
    }

    public static void drawBorderLine(BufferedImage image, int x1, int y1, int x2, int y2, Paint color, int thickness, Stroke stroke) throws IllegalArgumentException {
        if (x1 != x2 && y1 != y2) {
            throw new IllegalArgumentException("Border can only be drawn horizontal or vertical.");
        }
        if (x1 == x2) {
            x1 += thickness / 2;
            x2 += thickness / 2;
        } else {
            y1 += thickness / 2;
            y2 += thickness / 2;
        }
        Graphics2D graphics = image.createGraphics();
        graphics.setStroke(stroke);
        graphics.setPaint(color);
        graphics.drawLine(x1, y1, x2, y2);
        graphics.dispose();
    }

    public static void drawContinuousBorderLine(BufferedImage image, int x1, int y1, int x2, int y2, Paint color, int thickness) throws IllegalArgumentException {
        ImageUtils.drawBorderLine(image, x1, y1, x2, y2, color, thickness, new BasicStroke(thickness));
    }

    public static void drawDottedBorderLine(BufferedImage image, int x1, int y1, int x2, int y2, Paint color, int thickness) throws IllegalArgumentException {
        ImageUtils.drawBorderLine(image, x1, y1, x2, y2, color, thickness, new BasicStroke(thickness, 0, 2, 0.0f, new float[]{4.0f}, 10.0f));
    }

    public static void drawBorder(BufferedImage image, int posX, int posY, int width, int height, Paint color) {
        ImageUtils.drawBorder(image, posX, posY, width, height, color, DEFAULT_DASHED_STROKE);
    }

    public static void drawLine(BufferedImage image, int posXStart, int posYStart, int posXEnd, int posYEnd, int thickness, Paint color) {
        Graphics2D graphics = image.createGraphics();
        GeneralPath path = new GeneralPath();
        path.moveTo(posXStart, posYStart);
        path.lineTo(posXEnd, posYEnd);
        path.closePath();
        graphics.setStroke(new BasicStroke(thickness));
        graphics.setPaint(color);
        graphics.draw(path);
        graphics.dispose();
    }

    public static BufferedImage rotate(BufferedImage image, int rotation) {
        if (rotation == 0) {
            return image;
        }
        if (rotation == 90) {
            return ImageUtils.rotate90Degrees(image);
        }
        if (rotation == 180) {
            return ImageUtils.rotate180Degrees(image);
        }
        if (rotation == 270) {
            return ImageUtils.rotate270Degrees(image);
        }
        throw new UnsupportedOperationException(String.format("Rotation of %d is not supported", rotation));
    }

    public static BufferedImage rotate90Degrees(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = image.getColorModel() instanceof IndexColorModel ? new BufferedImage(height, width, image.getType(), (IndexColorModel)image.getColorModel()) : new BufferedImage(height, width, image.getType());
        Graphics2D g = newImage.createGraphics();
        g.translate((double)(height - width) / 2.0, (double)(width - height) / 2.0);
        g.rotate(Math.toRadians(90.0), (double)width / 2.0, (double)height / 2.0);
        g.drawRenderedImage(image, null);
        return newImage;
    }

    public static BufferedImage rotate180Degrees(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = image.getColorModel() instanceof IndexColorModel ? new BufferedImage(width, height, image.getType(), (IndexColorModel)image.getColorModel()) : new BufferedImage(width, height, image.getType());
        Graphics2D g = newImage.createGraphics();
        g.rotate(Math.toRadians(180.0), (double)width / 2.0, (double)height / 2.0);
        g.drawRenderedImage(image, null);
        return newImage;
    }

    public static BufferedImage rotate270Degrees(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage newImage = image.getColorModel() instanceof IndexColorModel ? new BufferedImage(height, width, image.getType(), (IndexColorModel)image.getColorModel()) : new BufferedImage(height, width, image.getType());
        Graphics2D g = newImage.createGraphics();
        g.translate((double)(height - width) / 2.0, (double)(width - height) / 2.0);
        g.rotate(Math.toRadians(270.0), (double)width / 2.0, (double)height / 2.0);
        g.drawRenderedImage(image, null);
        return newImage;
    }

    public static Rectangle rotate(int rotation, Rectangle bounds, int imageHeight, int imageWidth) {
        Rectangle newBounds = bounds;
        for (int index = 0; index < rotation; index += 90) {
            int height = imageHeight;
            if (index == 90) {
                height = imageWidth;
            }
            newBounds = ImageUtils.rotate90Degrees(rotation, newBounds, height);
        }
        return newBounds;
    }

    private static Rectangle rotate90Degrees(int rotation, Rectangle bounds, int imageHeight) {
        int x = bounds.x;
        int y = bounds.y;
        int height = bounds.height;
        int width = bounds.width;
        return new Rectangle(imageHeight - height - y, x, height, width);
    }

    public static void fillRect(BufferedImage image, Rectangle clippingRegion, int posX, int posY, int width, int height, Paint color) throws IllegalArgumentException {
        if (image.getWidth() < posX + width || image.getHeight() < posY + height) {
            throw new IllegalArgumentException("Image is too small");
        }
        Graphics2D graphics = image.createGraphics();
        if (clippingRegion != null) {
            graphics.setClip(clippingRegion);
        }
        graphics.setPaint(color);
        graphics.fillRect(posX, posY, width, height);
        graphics.dispose();
    }

    public static void fillRect(BufferedImage image, int posX, int posY, int width, int height, Paint color) throws IllegalArgumentException {
        ImageUtils.fillRect(image, null, posX, posY, width, height, color);
    }

    public static BufferedImage clinch(BufferedImage image, int width, int height) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double scaleX = (double)width / (double)imageWidth;
        double scaleY = (double)height / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
        return bilinearScaleOp.filter(image, new BufferedImage(width, height, image.getType()));
    }

    public static void drawRect(BufferedImage image, Rectangle rectangle, Paint color) {
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.dispose();
    }

    public static BufferedImage scaleToFit(BufferedImage image, int width, int height) {
        return ImageUtils.scaleToFit(image, new Rectangle(width, height));
    }

    public static BufferedImage scaleToFit(BufferedImage image, Rectangle boundary) {
        double backgroundRatio = (double)boundary.height / (double)boundary.width;
        double imageRatio = (double)image.getHeight() / (double)image.getWidth();
        double scale = 0.0;
        if (backgroundRatio > imageRatio) {
            scale = (double)boundary.width / (double)image.getWidth();
        } else if (backgroundRatio < imageRatio) {
            scale = (double)boundary.height / (double)image.getHeight();
        } else if (backgroundRatio == imageRatio) {
            scale = (double)boundary.height / (double)image.getHeight();
        }
        if (scale != 0.0) {
            BufferedImage backgroundImage = ImageUtils.createImage((int)((double)image.getWidth() * scale), (int)((double)image.getHeight() * scale), 2);
            Graphics2D graphics = backgroundImage.createGraphics();
            graphics.drawImage(image, boundary.x, boundary.y, (int)((double)image.getWidth() * scale), (int)((double)image.getHeight() * scale), null);
            graphics.dispose();
            return backgroundImage;
        }
        return image;
    }

    public static BufferedImage invert(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null for conversion");
        }
        if (image.getWidth() == 0 || image.getHeight() == 0) {
            throw new IllegalArgumentException("Invalid image size (width or height zero)");
        }
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int rgb = image.getRGB(i, j);
                Color color = new Color(rgb);
                Color newColor = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
                image.setRGB(i, j, newColor.getRGB());
            }
        }
        return image;
    }

    public static BufferedImage rotateImage(BufferedImage img, double degree) {
        return ImageUtils.rotateImage(img, degree, null, null, null, null, 0, 0);
    }

    public static BufferedImage rotateImage(BufferedImage img, double degree, Paint backgroundColor, Paint borderColor, Stroke borderStroke, RoundedRectangle roundedRectangle, int borderX, int borderY) {
        double angle = Math.toRadians(degree);
        return ImageUtils.tilt(img, angle, backgroundColor, borderColor, borderStroke, roundedRectangle, borderX, borderY);
    }

    public static BufferedImage tilt(BufferedImage image, double angle, Paint backgroundColor, Paint borderColor, Stroke borderStroke, RoundedRectangle roundedRectangle, int borderX, int borderY) {
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage result = new BufferedImage(neww, newh, 2);
        ImageUtils.fill(result, backgroundColor);
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(angle, w / 2, h / 2);
        g.drawRenderedImage(image, null);
        if (borderColor != null && borderStroke != null) {
            if (roundedRectangle != null) {
                ImageUtils.drawBorder(g, borderX, borderY, roundedRectangle, borderColor, borderStroke);
            } else {
                int width = image.getWidth();
                int height = image.getHeight();
                double degrees = Math.toDegrees(angle);
                if (height % 2 == 0) {
                    if (degrees == 180.0 && borderX == 0 && borderY == 0) {
                        borderX = 1;
                        borderY = 1;
                    } else if (degrees == 90.0 && borderX == 0 && borderY == 0) {
                        borderY = 1;
                    } else if (degrees == 270.0 && borderX == 0 && borderY == 0) {
                        borderX = 1;
                    }
                }
                ImageUtils.drawBorder(g, (Shape)new Rectangle(borderX, borderY, width - 1, height - 1), borderColor, borderStroke);
            }
        }
        g.dispose();
        return result;
    }

    public static Rectangle rotateRectangle(Rectangle rectangle, double degree) {
        Rectangle2D rotatedRectangle = ImageUtils.rotateRectanglePrecisely(rectangle, degree);
        int neww = (int)Math.floor(rotatedRectangle.getWidth());
        int newh = (int)Math.floor(rotatedRectangle.getHeight());
        return new Rectangle(neww, newh);
    }

    public static Rectangle2D rotateRectanglePrecisely(Rectangle rectangle, double degree) {
        double angle = Math.toRadians(degree);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = rectangle.width;
        int h = rectangle.height;
        return new Rectangle2D.Double(0.0, 0.0, (double)w * cos + (double)h * sin, (double)h * cos + (double)w * sin);
    }

    public static Rectangle revertRotation(Rectangle2D rectangle, double degree) {
        double angle = Math.toRadians(-degree);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        double neww = 1.0 / (Math.pow(cos, 2.0) - Math.pow(sin, 2.0)) * (width * cos - height * sin);
        double newh = 1.0 / (Math.pow(cos, 2.0) - Math.pow(sin, 2.0)) * (-width * sin + height * cos);
        return new Rectangle((int)Math.round(neww), (int)Math.round(newh));
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static int convertToPixels(float millimeter, int dpi) {
        return Math.round(millimeter * (float)dpi / 25.4f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadImageSource(File workingDirectory, String imageSource) throws IOException, IllegalArgumentException {
        URI sourceURI;
        BufferedImage returnImage = null;
        try {
            URL sourceURL = new URL(imageSource);
            sourceURI = new URI(sourceURL.getProtocol(), sourceURL.getHost(), sourceURL.getPath(), sourceURL.getQuery(), null);
        }
        catch (MalformedURLException exc) {
            sourceURI = ImageUtils.createURI(imageSource);
        }
        catch (URISyntaxException exc) {
            sourceURI = ImageUtils.createURI(imageSource);
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalArgumentException(String.format("Could not create URI from image source (%s)", imageSource), exc);
        }
        if (sourceURI.getScheme() == null || sourceURI.getScheme().equals("file")) {
            if (imageSource.contains("file://")) {
                imageSource = imageSource.replaceFirst("file://", "");
            } else if (imageSource.contains("file:")) {
                imageSource = imageSource.replaceFirst("file:", "");
            }
            sourceURI = new File(imageSource).isAbsolute() ? new File(imageSource).toURI() : new File(workingDirectory, imageSource).toURI();
        }
        InputStream inputStream = sourceURI.toURL().openStream();
        try {
            returnImage = FilenameUtils.isExtension((String)imageSource, (String[])new String[]{"svg", "SVG", "xml", "XML"}) ? SVG.SVGToBufferedImage(inputStream) : ImageIO.read(inputStream);
        }
        finally {
            StreamUtils.close(inputStream);
        }
        return returnImage;
    }

    private static URI createURI(String imageSource) {
        try {
            URI sourceURI = URI.create(imageSource);
            return sourceURI;
        }
        catch (Exception exc) {
            return new File(imageSource).toURI();
        }
    }

    public static LinkedList<Rectangle> combineAndAlignImages(LinkedList<BufferedImage> imagesToAlign, BufferedImage background, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, int rotation) throws IllegalArgumentException {
        if (imagesToAlign == null || imagesToAlign.size() == 0) {
            throw new IllegalArgumentException("No images to align vertically");
        }
        LinkedList<Rectangle> bounds = new LinkedList<Rectangle>();
        int width = 0;
        int height = 0;
        for (BufferedImage imageToAlign : imagesToAlign) {
            height += imageToAlign.getHeight();
            width = Math.max(width, imageToAlign.getWidth());
        }
        if (width > background.getWidth() || height > background.getHeight()) {
            throw new IllegalArgumentException("Background image is too small");
        }
        BufferedImage image = new BufferedImage(width, height, background.getType());
        Graphics2D graphics = image.createGraphics();
        int yPos = 0;
        for (BufferedImage imageToAlign : imagesToAlign) {
            int xPos = 0;
            if (horizontalAlignment == HorizontalAlignment.CENTER) {
                xPos += ImageUtils.getCenteringIndex(width, imageToAlign.getWidth());
            } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                xPos = xPos + width - imageToAlign.getWidth();
            }
            graphics.drawImage((Image)imageToAlign, xPos, yPos, null);
            bounds.add(new Rectangle(xPos, yPos, imageToAlign.getWidth(), imageToAlign.getHeight()));
            yPos += imageToAlign.getHeight();
        }
        graphics.dispose();
        Point point = ImageUtils.overlay(background, null, image, new Rectangle(image.getWidth(), image.getHeight()), 0, 0, background.getWidth(), background.getHeight(), rotation, horizontalAlignment, verticalAlignment);
        for (Rectangle rectangle : bounds) {
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        return bounds;
    }

    private static void applyQualityRenderingHints(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return ImageUtils.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return new BufferedImage(width, height, image.getType());
    }

    private static BufferedImage generateBlur(BufferedImage imgSource, int size, Paint color, double alpha, boolean blur) {
        GaussianFilter filter = new GaussianFilter((float)size);
        int imgWidth = imgSource.getWidth();
        int imgHeight = imgSource.getHeight();
        BufferedImage imgBlur = ImageUtils.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgBlur.createGraphics();
        ImageUtils.applyQualityRenderingHints(g2);
        g2.drawImage((Image)imgSource, 0, 0, null);
        g2.setComposite(AlphaComposite.getInstance(5, (float)alpha));
        g2.setPaint(color);
        g2.fillRect(0, 0, imgSource.getWidth(), imgSource.getHeight());
        g2.dispose();
        return blur ? filter.filter(imgBlur, null) : imgBlur;
    }

    public static BufferedImage applyShadow(BufferedImage imgSource, ShadowProperties properties) {
        return ImageUtils.applyShadow(imgSource, properties.getSize(), properties.getColor(), properties.getAlpha(), properties.isBlur(), properties.getAngle());
    }

    public static BufferedImage applyShadow(BufferedImage imgSource, int size, Paint color, double alpha, boolean blur, double angle) {
        BufferedImage result = ImageUtils.createCompatibleImage(imgSource, imgSource.getWidth() + size * 2, imgSource.getHeight() + size * 2);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage((Image)ImageUtils.generateShadow(imgSource, size, color, alpha, blur, angle), size, size, null);
        g2d.drawImage((Image)imgSource, 0, 0, null);
        g2d.dispose();
        return result;
    }

    private static BufferedImage generateShadow(BufferedImage imgSource, int size, Paint color, double alpha, boolean blur, double angle) {
        int imgWidth = imgSource.getWidth() + size * 2;
        int imgHeight = imgSource.getHeight() + size * 2;
        BufferedImage imgMask = ImageUtils.createCompatibleImage(imgWidth, imgHeight);
        Graphics2D g2 = imgMask.createGraphics();
        ImageUtils.applyQualityRenderingHints(g2);
        int x = (int)Math.round((double)size * Math.cos(Math.toRadians(angle)));
        int y = (int)Math.round((double)size * Math.sin(Math.toRadians(angle)));
        g2.drawImage((Image)imgSource, x, y, null);
        g2.dispose();
        BufferedImage imgGlow = ImageUtils.generateBlur(imgMask, size * 2, color, alpha, blur);
        return imgGlow;
    }

    public static BufferedImage ditherImage(BufferedImage image, DitheringThreshold ditheringThreshold) {
        if (image.getType() != 2) {
            BufferedImage img = ImageUtils.createImage(image.getWidth(), image.getHeight(), 2);
            Graphics graphics = img.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            image = img;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage inputRed = image;
        BufferedImage inputGray = image;
        BufferedImage redImg = ImageUtils.createRed(inputRed);
        BufferedImage grayScale = ImageUtils.createGrayscale(inputGray);
        int[][] alphaGR = new int[width][height];
        int[][] redGR = new int[width][height];
        int[][] grnGR = new int[width][height];
        int[][] bluGR = new int[width][height];
        int[][] alphaR = new int[width][height];
        int[][] redR = new int[width][height];
        int[][] grnR = new int[width][height];
        int[][] bluR = new int[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                alphaGR[x][y] = grayScale.getRGB(x, y) >> 24 & 0xFF;
                alphaR[x][y] = redImg.getRGB(x, y) >> 24 & 0xFF;
                redGR[x][y] = grayScale.getRGB(x, y) >> 16 & 0xFF;
                redR[x][y] = redImg.getRGB(x, y) >> 16 & 0xFF;
                grnGR[x][y] = grayScale.getRGB(x, y) >> 8 & 0xFF;
                grnR[x][y] = redImg.getRGB(x, y) >> 8 & 0xFF;
                bluGR[x][y] = grayScale.getRGB(x, y) & 0xFF;
                bluR[x][y] = redImg.getRGB(x, y) & 0xFF;
            }
        }
        int[][] pixel_alpha_grayImg = ImageUtils.dither(alphaGR, height, width, ditheringThreshold);
        int[][] pixel_red_grayImg = ImageUtils.dither(redGR, height, width, ditheringThreshold);
        int[][] pixel_grn_grayImg = ImageUtils.dither(grnGR, height, width, ditheringThreshold);
        int[][] pixel_blu_grayImg = ImageUtils.dither(bluGR, height, width, ditheringThreshold);
        int[][] pixel_alpha_redImg = ImageUtils.dither(alphaR, height, width, ditheringThreshold);
        int[][] pixel_red_redImg = ImageUtils.dither(redR, height, width, ditheringThreshold);
        int[][] pixel_grn_redImg = ImageUtils.dither(grnR, height, width, ditheringThreshold);
        int[][] pixel_blu_redImg = ImageUtils.dither(bluR, height, width, ditheringThreshold);
        BufferedImage grayScaleDither = ImageUtils.createImage(width, height, 2);
        BufferedImage redImgDither = ImageUtils.createImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixelGray = pixel_alpha_grayImg[x][y] << 24 | pixel_red_grayImg[x][y] << 16 | pixel_grn_grayImg[x][y] << 8 | pixel_blu_grayImg[x][y];
                grayScaleDither.setRGB(x, y, pixelGray);
                if (redR[x][y] >= 0) {
                    int pixelRed = pixel_alpha_redImg[x][y] << 24 | pixel_red_redImg[x][y] << 16 | pixel_grn_redImg[x][y] << 8 | pixel_blu_redImg[x][y];
                    redImgDither.setRGB(x, y, pixelRed);
                    continue;
                }
                int rgb = redImg.getRGB(x, y);
                int alphaPixel = 0xFFFFFF;
                int pixel = rgb & alphaPixel;
                redImgDither.setRGB(x, y, pixel);
            }
        }
        BufferedImage combined = ImageUtils.createImage(width, height, 2);
        Graphics g = combined.getGraphics();
        g.drawImage(grayScaleDither, 0, 0, null);
        g.drawImage(redImgDither, 0, 0, null);
        g.dispose();
        return combined;
    }

    private static BufferedImage createRed(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage input = image;
        int[][] alpha = new int[width][height];
        int[][] red = new int[width][height];
        int[][] grn = new int[width][height];
        int[][] blu = new int[width][height];
        BufferedImage img = image.getColorModel() instanceof IndexColorModel ? new BufferedImage(width, height, image.getType(), (IndexColorModel)image.getColorModel()) : new BufferedImage(width, height, image.getType());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel;
                alpha[x][y] = input.getRGB(x, y) >> 24 & 0xFF;
                red[x][y] = input.getRGB(x, y) >> 16 & 0xFF;
                grn[x][y] = input.getRGB(x, y) >> 8 & 0xFF;
                blu[x][y] = input.getRGB(x, y) & 0xFF;
                if (red[x][y] >= 200 && grn[x][y] <= 190 && blu[x][y] <= 190) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                if (red[x][y] >= 180 && grn[x][y] <= 170 && blu[x][y] <= 170) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                if (red[x][y] >= 150 && grn[x][y] <= 140 && blu[x][y] <= 140) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                if (red[x][y] >= 120 && grn[x][y] <= 110 && blu[x][y] <= 110) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                if (red[x][y] >= 80 && grn[x][y] <= 70 && blu[x][y] <= 70) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                if (red[x][y] >= 50 && grn[x][y] <= 40 && blu[x][y] <= 40) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                if (red[x][y] >= 20 && grn[x][y] <= 15 && blu[x][y] <= 15) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                if (red[x][y] >= 5 && grn[x][y] <= 2 && blu[x][y] <= 2) {
                    pixel = alpha[x][y] << 24 | red[x][y] << 16 | grn[x][y] << 8 | blu[x][y];
                    img.setRGB(x, y, pixel);
                    continue;
                }
                int rgb = img.getRGB(x, y);
                int alphaPixel = 0xFFFFFF;
                int pixel2 = rgb & alphaPixel;
                img.setRGB(x, y, pixel2);
            }
        }
        return img;
    }

    private static BufferedImage createGrayscale(BufferedImage image) {
        BufferedImage grayImage = image;
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(grayImage, grayImage);
        Graphics g = grayImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        image = grayImage;
        return image;
    }

    private static int[][] dither(int[][] pixel, int height, int width, DitheringThreshold ditheringThreshold) {
        for (int y = 0; y < height; ++y) {
            boolean nbottom = y < height - 1;
            for (int x = 0; x < width; ++x) {
                int newpixel;
                boolean nleft = x > 0;
                boolean nright = x < width - 1;
                int oldpixel = pixel[x][y];
                pixel[x][y] = newpixel = oldpixel < 128 ? 0 : 255;
                int error = oldpixel - newpixel;
                if (nright) {
                    int[] nArray = pixel[x + 1];
                    int n = y;
                    nArray[n] = nArray[n] + Math.round(7 * error / ditheringThreshold.getValue());
                }
                if (nleft & nbottom) {
                    int[] nArray = pixel[x - 1];
                    int n = y + 1;
                    nArray[n] = nArray[n] + Math.round(3 * error / ditheringThreshold.getValue());
                }
                if (nbottom) {
                    int[] nArray = pixel[x];
                    int n = y + 1;
                    nArray[n] = nArray[n] + Math.round(5 * error / ditheringThreshold.getValue());
                }
                if (!nright || !nbottom) continue;
                int[] nArray = pixel[x + 1];
                int n = y + 1;
                nArray[n] = nArray[n] + Math.round(error / ditheringThreshold.getValue());
            }
        }
        return pixel;
    }

    public static void applyColorThreshold(BufferedImage image, int threshold) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null for conversion");
        }
        if (image.getWidth() == 0 || image.getHeight() == 0) {
            throw new IllegalArgumentException("Invalid image size (width or height zero)");
        }
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int rgb = image.getRGB(i, j);
                Color color = new Color(rgb);
                int red = color.getRed() > threshold ? 255 : 0;
                int green = color.getGreen() > threshold ? 255 : 0;
                int blue = color.getBlue() > threshold ? 255 : 0;
                image.setRGB(i, j, new Color(red, green, blue).getRGB());
            }
        }
    }

    public static BufferedImage drawCenteredText(BufferedImage image, String initials, Font font, Paint color) {
        Graphics2D graphics = image.createGraphics();
        graphics.setFont(font);
        graphics.setPaint(color);
        Rectangle2D bounds = graphics.getFontMetrics(font).getStringBounds(initials, graphics);
        LineMetrics metrics = graphics.getFontMetrics(font).getLineMetrics(initials, graphics);
        int width = bounds.getBounds().width;
        int height = Math.round(metrics.getHeight());
        int x = image.getWidth() / 2 - width / 2;
        int y = image.getHeight() / 2 - height / 2 + (Math.round(metrics.getAscent()) - Math.round(metrics.getDescent() / 2.0f));
        graphics.drawString(initials, x, y);
        graphics.dispose();
        return image;
    }

    public static BufferedImage drawIconText(BufferedImage image, String text1, String text2, Font font1, Font font2, Paint color, int multiplicator) {
        Graphics2D graphics = image.createGraphics();
        graphics.setFont(font1);
        graphics.setPaint(color);
        Rectangle2D bounds1 = graphics.getFontMetrics(font1).getStringBounds(text1, graphics);
        LineMetrics metrics1 = graphics.getFontMetrics(font1).getLineMetrics(text1, graphics);
        graphics.setFont(font2);
        int width1 = bounds1.getBounds().width;
        int height1 = Math.round(metrics1.getHeight());
        int x1 = image.getWidth() / 2 - width1 / 2;
        int y1 = image.getHeight() / 2 - height1 / 2 + (Math.round(metrics1.getAscent()) - Math.round(metrics1.getDescent() / 2.0f));
        graphics.setFont(font1);
        graphics.drawString(text1, x1, y1);
        graphics.setFont(font2);
        graphics.drawString(text2, 14 * multiplicator, 28 * multiplicator);
        graphics.dispose();
        return image;
    }

    public static ArrayList<int[]> imageHistogram(BufferedImage input) {
        int[] rhistogram = new int[256];
        int[] ghistogram = new int[256];
        int[] bhistogram = new int[256];
        Arrays.fill(rhistogram, 0);
        Arrays.fill(ghistogram, 0);
        Arrays.fill(bhistogram, 0);
        for (int i = 0; i < input.getWidth(); ++i) {
            for (int j = 0; j < input.getHeight(); ++j) {
                int red = new Color(input.getRGB(i, j)).getRed();
                int green = new Color(input.getRGB(i, j)).getGreen();
                int blue = new Color(input.getRGB(i, j)).getBlue();
                int n = red;
                rhistogram[n] = rhistogram[n] + 1;
                int n2 = green;
                ghistogram[n2] = ghistogram[n2] + 1;
                int n3 = blue;
                bhistogram[n3] = bhistogram[n3] + 1;
            }
        }
        ArrayList<int[]> hist = new ArrayList<int[]>();
        hist.add(rhistogram);
        hist.add(ghistogram);
        hist.add(bhistogram);
        return hist;
    }

    private static ArrayList<int[]> histogramEqualizationLUT(BufferedImage input) {
        ArrayList<int[]> imageHist = ImageUtils.imageHistogram(input);
        ArrayList<int[]> imageLUT = new ArrayList<int[]>();
        int[] rhistogram = new int[256];
        int[] ghistogram = new int[256];
        int[] bhistogram = new int[256];
        Arrays.fill(rhistogram, 0);
        Arrays.fill(ghistogram, 0);
        Arrays.fill(bhistogram, 0);
        long sumr = 0L;
        long sumg = 0L;
        long sumb = 0L;
        float scale_factor = (float)(255.0 / (double)(input.getWidth() * input.getHeight()));
        for (int i = 0; i < rhistogram.length; ++i) {
            int valr = (int)((float)(sumr += (long)imageHist.get(0)[i]) * scale_factor);
            rhistogram[i] = valr > 255 ? 255 : valr;
            int valg = (int)((float)(sumg += (long)imageHist.get(1)[i]) * scale_factor);
            ghistogram[i] = valg > 255 ? 255 : valg;
            int valb = (int)((float)(sumb += (long)imageHist.get(2)[i]) * scale_factor);
            bhistogram[i] = valb > 255 ? 255 : valb;
        }
        imageLUT.add(rhistogram);
        imageLUT.add(ghistogram);
        imageLUT.add(bhistogram);
        return imageLUT;
    }

    public static BufferedImage histogramEqualization(BufferedImage original) {
        ArrayList<int[]> histLUT = ImageUtils.histogramEqualizationLUT(original);
        BufferedImage histogramEQ = new BufferedImage(original.getWidth(), original.getHeight(), original.getType());
        for (int i = 0; i < original.getWidth(); ++i) {
            for (int j = 0; j < original.getHeight(); ++j) {
                int alpha = new Color(original.getRGB(i, j)).getAlpha();
                int red = new Color(original.getRGB(i, j)).getRed();
                int green = new Color(original.getRGB(i, j)).getGreen();
                int blue = new Color(original.getRGB(i, j)).getBlue();
                red = histLUT.get(0)[red];
                green = histLUT.get(1)[green];
                blue = histLUT.get(2)[blue];
                int newPixel = new Color(red, green, blue, alpha).getRGB();
                histogramEQ.setRGB(i, j, newPixel);
            }
        }
        return histogramEQ;
    }

    public static void drawPie(Graphics2D graphics, Rectangle rectangle, Collection<Pair<Double, Color>> slices) {
        double total = 0.0;
        for (Pair<Double, Color> slice : slices) {
            total += slice.getFirst().doubleValue();
        }
        int roundedCurrentAngle = 0;
        Color currentColor = null;
        for (Pair<Double, Color> slice : slices) {
            currentColor = slice.getSecond();
            int startAngle = roundedCurrentAngle;
            int roundedArcAngle = (int)Math.round(slice.getFirst() * 360.0 / total);
            roundedCurrentAngle += roundedArcAngle;
            graphics.setColor(currentColor);
            graphics.fillArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, startAngle, roundedArcAngle);
        }
        if (roundedCurrentAngle < 360) {
            graphics.setColor(currentColor);
            graphics.fillArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, roundedCurrentAngle, 360 - roundedCurrentAngle);
        }
    }

    public static int roundUpToMultipleOf8(double width) {
        return (int)Math.ceil(width / 8.0) * 8;
    }
}

