/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ImageSerializationException;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.commons.codec.Charsets;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ImageSerializerTest {
    @Test(expected=ImageSerializationException.class)
    public void toBase64WithNull() throws SerializeException {
        ImageSerializer.toBase64(null);
    }

    @Test(expected=ImageSerializationException.class)
    @Ignore
    public void fromBase64WithInvalidImage() throws SerializeException {
        BufferedImage image = ImageSerializer.fromBase64(new byte[]{-1});
        Assert.assertNotNull((Object)image);
    }

    @Test(expected=SerializeException.class)
    public void fromBase64WithEmptyImage() throws SerializeException {
        BufferedImage image = ImageSerializer.fromBase64(new byte[0]);
        Assert.assertNotNull((Object)image);
    }

    @Test(expected=ImageSerializationException.class)
    @Ignore
    public void fromBase64WithNull() throws SerializeException {
        ImageSerializer.fromBase64(null);
    }

    @Test
    public void toBytesPerformanceTest() throws Exception {
        int iterations = 20;
        BufferedImage image = ImageIO.read(new File("data/ImageSerializerTest/wood.png"));
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            ImageSerializer.toBytes(image);
        }
        long finished = System.currentTimeMillis();
        System.out.println("toBytesPerformanceTest: Average time per iteration in milliseconds: " + (double)(finished - start) / (double)iterations);
    }

    @Test
    public void toBase64PerformanceTest() throws Exception {
        int iterations = 20;
        BufferedImage image = ImageIO.read(new File("data/ImageSerializerTest/wood.png"));
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            ImageSerializer.toBase64(image);
        }
        long finished = System.currentTimeMillis();
        System.out.println("toBase64PerformanceTest: Average time per iteration in milliseconds: " + (double)(finished - start) / (double)iterations);
    }

    @Test
    public void calculateHashPerformanceTest() throws Exception {
        int iterations = 1000;
        long start = System.currentTimeMillis();
        String base64 = "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";
        byte[] imageBytes = base64.getBytes(Charsets.UTF_8);
        for (int i = 0; i < iterations; ++i) {
            ImageSerializer.calculateHash(imageBytes);
        }
        long finished = System.currentTimeMillis();
        System.out.println("calculateHashPerformanceTest: Average time per iteration in milliseconds: " + (double)(finished - start) / (double)iterations);
    }

    @Test
    public void readImagePerformanceTest() throws Exception {
        int iterations = 20;
        long start = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            ImageSerializer.readImage(new File("data/ImageSerializerTest/wood.png"));
        }
        long finished = System.currentTimeMillis();
        System.out.println("readImagePerformanceTest: Average time per iteration in milliseconds: " + (double)(finished - start) / (double)iterations);
    }

    static {
        ImageIO.setUseCache(false);
    }
}

