/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.image.ImageSerializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.Charsets;

public class ImageSerializer {
    static ESLLogger logger = ESLLogger.getLogger(ImageSerializer.class);

    public static BufferedImage readImage(File imageFile) throws SerializeException {
        try {
            BufferedImage image = ImageIO.read(imageFile);
            ImageSerializer.checkImage(image);
            return image;
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from '%s'", imageFile.getPath());
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from '%s'", imageFile.getPath());
        }
    }

    public static BufferedImage readImage(InputStream inputStream) throws SerializeException {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            ImageSerializer.checkImage(image);
            return image;
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from stream", new Object[0]);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from stream", new Object[0]);
        }
    }

    public static BufferedImage readImage(ImageInputStream inputStream) throws SerializeException {
        try {
            BufferedImage image = ImageIO.read(inputStream);
            ImageSerializer.checkImage(image);
            return image;
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from stream", new Object[0]);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc, "Failed to read image from stream", new Object[0]);
        }
    }

    public static String toBase64String(BufferedImage bufferedImage) throws SerializeException {
        try {
            return DatatypeConverter.printBase64Binary((byte[])ImageSerializer.toBinary(bufferedImage));
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc);
        }
    }

    public static BufferedImage fromBase64(byte[] encodedImage) throws SerializeException {
        return ImageSerializer.fromBase64String(ImageSerializer.toString(encodedImage));
    }

    public static BufferedImage fromBase64String(String encodedImage) throws SerializeException {
        return ImageSerializer.fromBytes(DatatypeConverter.parseBase64Binary((String)encodedImage));
    }

    public static byte[] fromBase64StringToBytes(String encodedImage) throws SerializeException {
        return ImageSerializer.toBytes(ImageSerializer.fromBase64String(encodedImage));
    }

    public static byte[] toBase64(BufferedImage bufferedImage) throws SerializeException {
        try {
            return ImageSerializer.toBinary(DatatypeConverter.printBase64Binary((byte[])ImageSerializer.toBinary(bufferedImage)));
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc);
        }
    }

    public static byte[] toBytes(BufferedImage bufferedImage) throws SerializeException {
        try {
            return ImageSerializer.toBinary(bufferedImage);
        }
        catch (IOException exc) {
            throw new ImageSerializationException(exc);
        }
    }

    public static BufferedImage fromBytes(byte[] data) throws SerializeException {
        return ImageSerializer.fromBytesCached(data);
    }

    public static BufferedImage fromBytes(byte[] data, boolean cached) throws SerializeException {
        if (cached) {
            return ImageSerializer.fromBytesCached(data);
        }
        return ImageSerializer.fromBytesUncached(data);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage fromBytesCached(byte[] data) throws SerializeException {
        BufferedImage bufferedImage;
        ByteArrayInputStream input = null;
        try {
            input = new ByteArrayInputStream(data);
            bufferedImage = ImageSerializer.readImage(input);
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            try {
                throw new ImageSerializationException(exc);
                catch (RuntimeException exc2) {
                    throw new ImageSerializationException(exc2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(input);
                throw throwable;
            }
        }
        StreamUtils.close(input);
        return bufferedImage;
    }

    public static BufferedImage fromBytesUncached(byte[] data) throws SerializeException {
        MemoryCacheImageInputStream input = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
            input = new MemoryCacheImageInputStream(byteArrayInputStream);
            BufferedImage bufferedImage = ImageSerializer.readImage(input);
            return bufferedImage;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new ImageSerializationException(exc);
        }
        catch (RuntimeException exc) {
            throw new ImageSerializationException(exc);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static void checkImage(BufferedImage image) throws SerializeException {
        if (image == null) {
            throw new ImageSerializationException("Unknown image file format", new Object[0]);
        }
    }

    public static boolean compareEncodedImages(byte[] firstImage, byte[] secondImage) {
        if (firstImage != null && secondImage != null && firstImage.length == secondImage.length) {
            for (int i = 0; i < firstImage.length; ++i) {
                if (firstImage[i] == secondImage[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static byte[] toBinary(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", output);
        return output.toByteArray();
    }

    private static String toString(byte[] data) {
        return new String(data, Charsets.UTF_8);
    }

    private static byte[] toBinary(String data) {
        return data.getBytes(Charsets.UTF_8);
    }

    public static byte[] calculateHash(byte[] image) throws SerializeException {
        try {
            return MessageDigest.getInstance("SHA-256").digest(image);
        }
        catch (NoSuchAlgorithmException exc) {
            throw new SerializeException(exc);
        }
    }

    public static boolean compareHashes(byte[] firstHash, byte[] secondHash) {
        return Arrays.equals(firstHash, secondHash);
    }
}

