/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.gui.InternalFramesManager;
import at.mrdevelopment.toolkit.image.BufferedImagePanel;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;

public class ImageFrame {
    static ESLLogger logger = ESLLogger.getLogger(ImageFrame.class);
    private final String title;
    private final ImageIcon icon;
    private JLabel statusBar = new JLabel();
    private BufferedImagePanel imagePanel;
    private BufferedImage image;

    public static ImageFrame createImageFrame(String title, BufferedImage image, ImageIcon icon) {
        ImageFrame imageFrame = new ImageFrame(title, image, icon);
        imageFrame.showNormalFrame();
        return imageFrame;
    }

    public static ImageFrame createInternalImageFrame(String title, BufferedImage image, InternalFramesManager internalFramesManager, ImageIcon icon) {
        ImageFrame imageFrame = new ImageFrame(title, image, icon);
        imageFrame.showInternalFrame(internalFramesManager);
        return imageFrame;
    }

    private ImageFrame(String title, BufferedImage image, ImageIcon icon) {
        this.title = title;
        this.icon = icon;
        this.image = image;
        this.imagePanel = new BufferedImagePanel(image);
    }

    private void showNormalFrame() {
        JFrame frame = new JFrame();
        this.createContent(frame.getContentPane());
        this.updateStatusBar();
        frame.setIconImage(this.icon.getImage());
        frame.setTitle(this.title);
        frame.setResizable(true);
        frame.setDefaultCloseOperation(2);
        frame.setJMenuBar(this.createMenuBar());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private void showInternalFrame(InternalFramesManager internalFramesManager) {
        JInternalFrame frame = new JInternalFrame();
        this.createContent(frame.getContentPane());
        this.updateStatusBar();
        frame.setFrameIcon(this.icon);
        frame.setTitle(this.title);
        frame.setClosable(true);
        frame.setMaximizable(true);
        frame.setResizable(true);
        frame.setMinimumSize(new Dimension(100, 100));
        frame.setJMenuBar(this.createMenuBar());
        frame.pack();
        internalFramesManager.addFrame(frame);
    }

    private JMenuBar createMenuBar() {
        JMenuItem save = new JMenuItem("Save...");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageFrame.this.onSaveImage();
            }
        });
        JMenuItem rotateImageLeft = new JMenuItem("Rotate left");
        rotateImageLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageFrame.this.onRotateImage(270);
            }
        });
        JMenuItem rotateImageRight = new JMenuItem("Rotate right");
        rotateImageRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageFrame.this.onRotateImage(90);
            }
        });
        JMenu imageMenu = new JMenu("Image");
        imageMenu.add(rotateImageLeft);
        imageMenu.add(rotateImageRight);
        imageMenu.add(save);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(imageMenu);
        return menuBar;
    }

    private void createContent(Container container) {
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.imagePanel = new BufferedImagePanel(this.image);
        this.imagePanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                double scale = event.getUnitsToScroll() < 0 ? ImageFrame.this.imagePanel.getScale() * 2.0 : ImageFrame.this.imagePanel.getScale() / 2.0;
                ImageFrame.this.imagePanel.setScale(Math.max(0.25, Math.min(16.0, scale)));
                ImageFrame.this.updateStatusBar();
            }
        });
        container.setLayout(new BorderLayout());
        container.add((Component)new JScrollPane(this.imagePanel), "Center");
        container.add((Component)this.statusBar, "Last");
    }

    private void updateStatusBar() {
        int scale = (int)Math.round(this.imagePanel.getScale() * 100.0);
        String statusText = String.format("%d x %d pixels - %d%%", this.image.getWidth(), this.image.getHeight(), scale);
        this.statusBar.setText(statusText);
    }

    private void onSaveImage() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new FileNameExtensionFilter("Portable Network Graphics File (.png)", "png"));
        int returnState = fileChooser.showSaveDialog(null);
        if (returnState == 0) {
            File file = fileChooser.getSelectedFile();
            if (FilenameUtils.getExtension((String)file.getPath()).isEmpty()) {
                file = new File(file.getPath() + ".png");
            }
            try {
                ImageIO.write((RenderedImage)this.image, "PNG", file);
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(null, "Could not write image file", "Save image", 0);
                logger.logException(exc);
            }
        }
    }

    private void onRotateImage(int rotation) {
        this.image = ImageUtils.rotate(this.image, rotation);
        this.imagePanel.changeImage(this.image);
        this.updateStatusBar();
    }
}

