/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import at.mrdevelopment.toolkit.image.ColorMapping;

public abstract class DualColorMapping
implements ColorMapping {
    private int[] baseColorComponents;
    private int[] topColorComponents;

    public DualColorMapping(int[] topColorComponents) {
        this(ColorMapping.WHITE, topColorComponents);
    }

    public DualColorMapping(int[] baseColorComponents, int[] topColorComponents) {
        this.baseColorComponents = baseColorComponents;
        this.topColorComponents = topColorComponents;
    }

    @Override
    public int[] getColor(int value) {
        return value == 0 ? this.baseColorComponents : this.topColorComponents;
    }

    @Override
    public int getValue(int[] color) {
        if (color.length == 1) {
            return 0;
        }
        if (color.length == 3 || color.length == 4) {
            return color[0] == this.topColorComponents[0] && color[1] == this.topColorComponents[1] && color[2] == this.topColorComponents[2] ? 1 : 0;
        }
        throw new RuntimeException("No color mapping available");
    }
}

