/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BufferedImagePanel
extends JPanel {
    private static final double DEFAULT_SCALE = 1.0;
    private static final int DEFAULT_BORDER = 1;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.LIGHT_GRAY;
    private BufferedImage image;
    private double scale;
    private int border;

    public BufferedImagePanel(BufferedImage image) {
        this(image, 1.0, 1, DEFAULT_BACKGROUND_COLOR);
    }

    public BufferedImagePanel(BufferedImage image, double scale) {
        this(image, scale, 1, DEFAULT_BACKGROUND_COLOR);
    }

    public BufferedImagePanel(BufferedImage image, double scale, int border, Color backgroundColor) {
        super(null);
        this.image = image;
        this.scale = scale;
        this.border = border;
        this.setBackground(backgroundColor);
        this.applyImageSize();
    }

    public void changeImage(BufferedImage image) {
        if (image != null) {
            this.image = image;
            this.applyImageSize();
        }
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.applyImageSize();
    }

    public double getScale() {
        return this.scale;
    }

    private void applyImageSize() {
        if (this.image != null) {
            int width = (int)Math.round((double)this.image.getWidth() * this.scale) + 2 * this.border;
            int height = (int)Math.round((double)this.image.getHeight() * this.scale) + 2 * this.border;
            Dimension contentSize = new Dimension(width, height);
            this.setPreferredSize(contentSize);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.image != null) {
            int width = (int)Math.round((double)this.image.getWidth() * this.scale);
            int height = (int)Math.round((double)this.image.getHeight() * this.scale);
            graphics.drawImage(this.image, this.border, this.border, width + this.border, height + this.border, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        }
    }

    public int getImageWidth() {
        return this.image != null ? this.image.getWidth() : this.getPreferredSize().width - 2 * this.border;
    }

    public int getImageHeight() {
        return this.image != null ? this.image.getHeight() : this.getPreferredSize().height - 2 * this.border;
    }
}

