/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.authentication.UserId;
import java.net.InetAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class WebserviceRequest {
    private final URI requestUri;
    private final InetAddress remoteHost;
    private final boolean gzipEncodingAccepted;
    private final UserId user;
    private final HttpEntity body;
    private final Map<String, String> requestParameters = new HashMap<String, String>();

    public WebserviceRequest(URI requestUri, InetAddress remoteHost, boolean gzipEncodingAccepted, UserId user, HttpEntity body) {
        this.requestUri = requestUri;
        this.remoteHost = remoteHost;
        this.gzipEncodingAccepted = gzipEncodingAccepted;
        this.user = user;
        this.body = body;
        this.parseRequestUri();
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public InetAddress getRemoteHost() {
        return this.remoteHost;
    }

    public boolean isGzipEncodingAccepted() {
        return this.gzipEncodingAccepted;
    }

    public UserId getUser() {
        return this.user;
    }

    public HttpEntity getBody() {
        return this.body;
    }

    public String getUrlBaseName() {
        return FilenameUtils.getBaseName((String)this.requestUri.getPath());
    }

    private void parseRequestUri() {
        List pairs = URLEncodedUtils.parse((URI)this.requestUri, (String)"UTF-8");
        for (NameValuePair pair : pairs) {
            this.requestParameters.put(pair.getName(), pair.getValue());
        }
    }
}

