/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpResource;
import at.mrdevelopment.toolkit.http.StaticFileHttpRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;

public class StaticFileHttpResource
implements HttpResource {
    private final String directoryIndex;
    private final String documentRoot;

    public StaticFileHttpResource(String directoryIndex, String documentRoot) {
        this.directoryIndex = directoryIndex;
        this.documentRoot = documentRoot;
    }

    @Override
    public void handleIndexEntity(WebserviceResponse response, String requestPath) throws SerializeException {
        InputStreamEntity entity;
        String path = this.documentRoot + requestPath + this.directoryIndex;
        InputStream resourceStream = StaticFileHttpResource.class.getResourceAsStream(path);
        InputStreamEntity inputStreamEntity = entity = resourceStream != null ? new InputStreamEntity(resourceStream, -1L) : null;
        if (entity != null) {
            entity.setContentType(this.getIndexContentType().getValue());
            response.respondEntity((HttpEntity)entity, 200);
        } else {
            response.respondFileNotFound();
        }
    }

    @Override
    public HttpContentType getIndexContentType() {
        return StaticFileHttpRequestHandler.getContentType(this.directoryIndex);
    }

    @Override
    public InputStreamEntity getEntityForResourcePath(String localPath) {
        InputStream resourceStream = StaticFileHttpResource.class.getResourceAsStream(localPath);
        if (resourceStream != null) {
            InputStreamEntity body = new InputStreamEntity(resourceStream, -1L);
            body.setContentType(StaticFileHttpRequestHandler.getContentType(localPath).getValue());
            return body;
        }
        return null;
    }
}

