/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.HttpContentType;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.HttpResource;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;

public class StaticFileHttpRequestHandler
implements WebserviceRequestHandler {
    private final HttpResource indexResource;
    private final String documentRoot;

    public StaticFileHttpRequestHandler(String documentRoot, HttpResource indexResource) {
        this.documentRoot = documentRoot;
        this.indexResource = indexResource;
    }

    @Route(method=HttpRequestMethod.GET, route="/.*")
    public void getFile(WebserviceRequest request, WebserviceResponse response) throws Exception {
        String requestPath = request.getRequestUri().getPath();
        if (requestPath.endsWith("/")) {
            this.indexResource.handleIndexEntity(response, requestPath);
        } else {
            this.getFile(this.documentRoot + requestPath, response);
        }
    }

    private void getFile(String localPath, WebserviceResponse response) throws Exception {
        InputStreamEntity body = this.indexResource.getEntityForResourcePath(localPath);
        if (body != null) {
            response.respondEntity((HttpEntity)body, 200);
        } else {
            response.respondFileNotFound();
        }
    }

    public static HttpContentType getContentType(String path) {
        String fileExtension = FilenameUtils.getExtension((String)path);
        if (fileExtension.equals("css")) {
            return HttpContentType.CSS;
        }
        if (fileExtension.equals("xsl")) {
            return HttpContentType.XML;
        }
        if (fileExtension.equals("xml")) {
            return HttpContentType.XML;
        }
        if (fileExtension.equals("png")) {
            return HttpContentType.PNG;
        }
        return HttpContentType.HTML_UTF8;
    }

    @Override
    public String getRouteFromPattern(String route) {
        return route;
    }
}

