/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.RequestRoutingTable;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class RoutingTableTest {
    @Test
    public void lookupStaticRoute() throws URISyntaxException {
        WebserviceRequestHandler handler = new WebserviceRequestHandler(){

            @Override
            public String getRouteFromPattern(String route) {
                return route;
            }
        };
        Method execution = handler.getClass().getDeclaredMethods()[0];
        RequestRoutingTable routingTable = new RequestRoutingTable();
        routingTable.addRoute("/service/labels/registered.xml", handler, execution, HttpRequestMethod.GET, null);
        Assert.assertTrue((boolean)routingTable.lookup(new URI("/service/labels/registered.xml")));
        Assert.assertFalse((boolean)routingTable.lookup(new URI("/service/labels.xml")));
    }

    @Test
    public void lookupPatternRoute() throws URISyntaxException {
        WebserviceRequestHandler handler = new WebserviceRequestHandler(){

            @Override
            public String getRouteFromPattern(String route) {
                return route;
            }
        };
        Method execution = handler.getClass().getDeclaredMethods()[0];
        RequestRoutingTable routingTable = new RequestRoutingTable();
        routingTable.addRoute("/service/labels/:key.xml", handler, execution, HttpRequestMethod.GET, "[0-9a-fA-F]{8}");
        Assert.assertTrue((boolean)routingTable.lookup(new URI("/service/labels/B20001A6.xml")));
        Assert.assertTrue((boolean)routingTable.lookup(new URI("/service/labels/A1000001.xml")));
        Assert.assertTrue((boolean)routingTable.lookup(new URI("/service/labels/cafebabe.xml")));
        Assert.assertTrue((boolean)routingTable.lookup(new URI("/service/labels/B16B00B5.xml")));
        Assert.assertFalse((boolean)routingTable.lookup(new URI("/service/labels/B20.xml")));
        Assert.assertFalse((boolean)routingTable.lookup(new URI("/service/labels/ABCDEFGH.xml")));
        Assert.assertFalse((boolean)routingTable.lookup(new URI("/service/labels.xml")));
    }

    static {
        ESLLogger.initLogger(false);
    }
}

