/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestRoutingTable {
    static ESLLogger logger = ESLLogger.getLogger(RequestRoutingTable.class);
    private Map<Pattern, RoutingEntry> routingTable = new HashMap<Pattern, RoutingEntry>();

    public void addRoute(String route, WebserviceRequestHandler handler, Method execution, HttpRequestMethod requestMethod, String keyPattern) {
        if (keyPattern != null && !keyPattern.isEmpty()) {
            route = route.replace(":key", Pattern.compile(keyPattern).pattern());
        }
        logger.info("Routing %s %s to %s.%s", new Object[]{requestMethod, route, handler.getClass().getSimpleName(), execution.getName()});
        this.routingTable.put(Pattern.compile(route), new RoutingEntry(handler, execution, requestMethod));
    }

    public boolean lookup(URI uri) {
        for (Pattern pattern : this.routingTable.keySet()) {
            Matcher matcher = pattern.matcher(uri.getPath());
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    public RoutingEntry getRoutingEntry(URI uri, String requestMethod) {
        for (Map.Entry<Pattern, RoutingEntry> entry : this.routingTable.entrySet()) {
            Pattern pattern = entry.getKey();
            RoutingEntry routingEntry = entry.getValue();
            Matcher matcher = pattern.matcher(uri.getPath());
            if (!matcher.matches() || !requestMethod.equals(routingEntry.getRequestMethod().toString())) continue;
            return routingEntry;
        }
        return null;
    }

    public void addPathPrefix(String prefix) {
        HashMap<Pattern, RoutingEntry> newRoutingTable = new HashMap<Pattern, RoutingEntry>();
        for (Map.Entry<Pattern, RoutingEntry> entry : this.routingTable.entrySet()) {
            RoutingEntry routingEntry = new RoutingEntry(entry.getValue().getHandler(), entry.getValue().getExecution(), entry.getValue().getRequestMethod(), prefix);
            newRoutingTable.put(Pattern.compile(prefix + entry.getKey().pattern()), routingEntry);
        }
        this.routingTable = newRoutingTable;
    }

    public static class RoutingEntry {
        private final WebserviceRequestHandler handler;
        private final HttpRequestMethod requestMethod;
        private final Method requestHandler;
        private final String prefix;

        public RoutingEntry(WebserviceRequestHandler handler, Method execution, HttpRequestMethod requestMethod) {
            this(handler, execution, requestMethod, null);
        }

        public RoutingEntry(WebserviceRequestHandler handler, Method execution, HttpRequestMethod requestMethod, String prefix) {
            this.handler = handler;
            this.requestMethod = requestMethod;
            this.requestHandler = execution;
            this.prefix = prefix;
        }

        public WebserviceRequestHandler getHandler() {
            return this.handler;
        }

        public Method getExecution() {
            return this.requestHandler;
        }

        public HttpRequestMethod getRequestMethod() {
            return this.requestMethod;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean hasPrefix() {
            return this.prefix != null;
        }
    }
}

