/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.http.HttpWorker;
import at.mrdevelopment.toolkit.http.HttpWorkerThreadFactory;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class RequestListenerThread
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(RequestListenerThread.class);
    private static final int DEFAULT_SERVER_SOCKET_BACKLOG = 50;
    private static final String THREAD_PREFIX = "http-worker-pool-";
    private final ServerSocket serverSocket;
    private final HttpService httpService;
    private final ExecutorService executor;
    private final DefaultBHttpServerConnectionFactory connectionFactory;
    private volatile boolean shutdownRequested = false;

    public RequestListenerThread(int port, boolean useSSL, HttpRequestHandlerMapper registry, int threadPoolSize, int workerThreadPriority, SSLServerSocketFactory sslSocketFactory, boolean verifyClientCertificates, InetAddress address) throws WebserviceException {
        super(String.format("%s-request-listener-port-%d", useSSL ? "https" : "http", port));
        try {
            this.serverSocket = this.createServerSocket(port, useSSL, verifyClientCertificates, sslSocketFactory, address);
            ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
            this.httpService = new HttpService((HttpProcessor)httpProcessor, (ConnectionReuseStrategy)new NoConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory(), registry);
            HttpWorkerThreadFactory threadFactory = new HttpWorkerThreadFactory(THREAD_PREFIX, workerThreadPriority);
            this.executor = Executors.newFixedThreadPool(threadPoolSize, threadFactory);
            this.connectionFactory = new DefaultBHttpServerConnectionFactory(ConnectionConfig.custom().setBufferSize(8192).build());
        }
        catch (Exception exc) {
            throw new WebserviceException(exc);
        }
    }

    private ServerSocket createServerSocket(int port, boolean useSSLSocket, boolean verifyClientCertificates, SSLServerSocketFactory sslSocketFactory, InetAddress address) throws IOException {
        if (useSSLSocket) {
            if (sslSocketFactory == null) {
                return address == null ? SSLServerSocketFactory.getDefault().createServerSocket(port) : SSLServerSocketFactory.getDefault().createServerSocket(port, 50, address);
            }
            SSLServerSocket socket = (SSLServerSocket)sslSocketFactory.createServerSocket(port, 50, address);
            socket.setNeedClientAuth(verifyClientCertificates);
            return socket;
        }
        return new ServerSocket(port, 50, address);
    }

    @Override
    public void shutdown() {
        logger.info("Shutdown RequestListenerThread");
        this.shutdownRequested = true;
        this.executor.shutdownNow();
        this.interrupt();
    }

    @Override
    public void interrupt() {
        super.interrupt();
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        logger.info("Listening on port " + this.serverSocket.getLocalPort());
        while (!this.shutdownRequested) {
            try {
                Socket socket = this.serverSocket.accept();
                socket.setTcpNoDelay(true);
                socket.setSoTimeout(30000);
                DefaultBHttpServerConnection connection = this.connectionFactory.createConnection(socket);
                HttpWorker worker = new HttpWorker(this.httpService, (HttpServerConnection)connection);
                this.executor.execute(worker);
            }
            catch (SocketException exc) {
                if (this.shutdownRequested) continue;
                logger.warn("Socket error while initialising worker thread: " + exc.getMessage());
                break;
            }
            catch (IOException exc) {
                logger.warn("HTTP input/output error while initialising worker thread: " + exc.getMessage());
            }
        }
    }
}

