/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.http.HttpEntity;

public class MultipartFileParser {
    public File writeFileFromStream(HttpEntity body, String toBasepath) throws IllegalStateException, IOException {
        return this.writeFileFromStream(body, null, toBasepath);
    }

    public String writeFileFromStream(HttpEntity body, OutputStream outputStream) throws IllegalStateException, IOException {
        File file = this.writeFileFromStream(body, outputStream, null);
        return file != null ? file.getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeFileFromStream(HttpEntity body, OutputStream outputStream, String toBasepath) throws IllegalStateException, IOException {
        File file = null;
        String contentType = body.getContentType().getValue();
        int boundaryIndex = contentType.indexOf("boundary=");
        byte[] boundary = contentType.substring(boundaryIndex + 9).getBytes();
        MultipartStream multipartStream = new MultipartStream(body.getContent(), boundary);
        boolean nextPart = multipartStream.skipPreamble();
        while (nextPart) {
            String[] headers = multipartStream.readHeaders().split(";");
            String filename = null;
            for (String header : headers) {
                if (!header.contains("filename")) continue;
                filename = header.split("[=|\"]")[2];
            }
            if (filename == null) continue;
            OutputStream data = null;
            try {
                if (outputStream == null) {
                    file = new File(toBasepath + "/" + filename);
                    data = new FileOutputStream(file);
                } else {
                    file = new File(filename);
                    data = outputStream;
                }
                multipartStream.readBodyData(data);
                nextPart = multipartStream.readBoundary();
            }
            catch (Throwable throwable) {
                StreamUtils.close(data);
                throw throwable;
            }
            StreamUtils.close(data);
        }
        return file;
    }
}

