/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.http;

import at.mrdevelopment.toolkit.Abortable;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.RequestAbortable;
import at.mrdevelopment.toolkit.http.HttpServiceClientConfiguration;
import at.mrdevelopment.toolkit.http.HttpWorkerThreadFactory;
import at.mrdevelopment.toolkit.http.IgnoreRequestFailedHandler;
import at.mrdevelopment.toolkit.http.PendingHttpRequestsCache;
import at.mrdevelopment.toolkit.http.RequestAbortedException;
import at.mrdevelopment.toolkit.http.RequestFailedHandler;
import at.mrdevelopment.toolkit.http.RequestListener;
import at.mrdevelopment.toolkit.http.ResponseHandler;
import at.mrdevelopment.toolkit.http.ResponseHandlerWrapper;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultUserTokenHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpServiceClient {
    static ESLLogger logger = ESLLogger.getLogger(HttpServiceClient.class);
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 120000;
    private static final boolean DEFAULT_GZIP_ENCODING_ENABLED = true;
    private static final String THREAD_PREFIX = "http-client-pool-";
    private final Set<RequestListener> listeners = new CopyOnWriteArraySet<RequestListener>();
    private final ExecutorService executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(32), new HttpWorkerThreadFactory("http-client-pool-", 1), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final CredentialsProvider credentialsProvider;
    private final HttpHost httpHost;
    private final CloseableHttpClient httpClient;
    private final String pathPrefix;
    private final AtomicBoolean gzipEncodingEnabled;
    private final PendingHttpRequestsCache pendingRequestCache;
    private final Map<String, Object> httpClientParams;
    private final AuthCache authCache;

    public HttpServiceClient(String host, int port, boolean useSSL, HttpServiceClientConfiguration configuration, Charset credentialsCharset) throws InitializationException {
        this(host, port, useSSL, null, configuration.getHttpClientParams(), configuration.getTrustManager(), configuration.getKeyManagers(), configuration.isHostnameVerfication(), credentialsCharset, true);
    }

    public HttpServiceClient(String host, int port, boolean useSSL, HttpServiceClientConfiguration configuration) throws InitializationException {
        this(host, port, useSSL, null, configuration, true);
    }

    public HttpServiceClient(String host, int port, boolean useSSL) throws InitializationException {
        this(host, port, useSSL, null, HttpServiceClientConfiguration.createDefaultConfiguration(), true);
    }

    public HttpServiceClient(String host, int port, boolean useSSL, String pathPrefix) throws InitializationException {
        this(host, port, useSSL, pathPrefix, HttpServiceClientConfiguration.createDefaultConfiguration(), true);
    }

    public HttpServiceClient(String host, int port, boolean useSSL, String pathPrefix, HttpServiceClientConfiguration configuration, boolean gzipEnabled) throws InitializationException {
        this(host, port, useSSL, pathPrefix, configuration.getHttpClientParams(), configuration.getTrustManager(), configuration.getKeyManagers(), configuration.isHostnameVerfication(), null, gzipEnabled);
    }

    private HttpServiceClient(String host, int port, boolean useSSL, String pathPrefix, Map<String, Object> httpClientParams, X509TrustManager trustManager, KeyManager[] keyManagers, boolean verifyHostname, Charset credentialsCharset, boolean gzipEnabled) throws InitializationException {
        try {
            this.httpClientParams = httpClientParams;
            this.pendingRequestCache = new PendingHttpRequestsCache();
            this.addRequestListener(this.pendingRequestCache);
            this.pathPrefix = this.preparePrefix(pathPrefix);
            this.httpHost = new HttpHost(host, port, useSSL ? "https" : "http");
            this.gzipEncodingEnabled = new AtomicBoolean(gzipEnabled);
            X509TrustManager certificateTrustManager = trustManager;
            logger.info("Imported %d accepted issuers", certificateTrustManager.getAcceptedIssuers().length);
            SSLContext sslContext = null;
            if (useSSL) {
                if (trustManager != null && keyManagers != null) {
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(keyManagers, new TrustManager[]{certificateTrustManager}, null);
                } else if (trustManager != null) {
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, new TrustManager[]{certificateTrustManager}, null);
                } else {
                    sslContext = SSLContext.getDefault();
                }
                SSLContext.setDefault(sslContext);
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();
            this.credentialsProvider = new BasicCredentialsProvider();
            SSLConnectionSocketFactory sslConnectionFactory = useSSL ? new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (HostnameVerifier)(verifyHostname ? new DefaultHostnameVerifier() : new NoopHostnameVerifier())) : null;
            RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            if (useSSL) {
                registryBuilder.register("https", (Object)sslConnectionFactory);
            }
            Registry registry = registryBuilder.build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            headers.add(new BasicHeader("Content-Encoding", "UTF-8"));
            HttpClientBuilder builder = HttpClients.custom().disableContentCompression().addInterceptorFirst(this.createRequestInterceptor()).addInterceptorFirst(this.createResponseInterceptor()).setUserTokenHandler((UserTokenHandler)DefaultUserTokenHandler.INSTANCE).setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultCredentialsProvider(this.credentialsProvider).setDefaultRequestConfig(requestConfig).setDefaultHeaders(headers);
            if (useSSL) {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
            }
            this.httpClient = builder.build();
            this.authCache = new BasicAuthCache();
            BasicScheme basicScheme = credentialsCharset != null ? new BasicScheme(credentialsCharset) : new BasicScheme();
            this.authCache.put(this.httpHost, (AuthScheme)basicScheme);
        }
        catch (Exception exc) {
            throw new InitializationException(exc);
        }
    }

    private BasicHttpContext createContext() {
        BasicHttpContext httpContext = new BasicHttpContext();
        httpContext.setAttribute("http.auth.auth-cache", (Object)this.authCache);
        if (this.httpClientParams != null && this.httpClientParams.size() > 0) {
            for (Map.Entry<String, Object> entry : this.httpClientParams.entrySet()) {
                this.httpClient.getParams().setParameter(entry.getKey(), entry.getValue());
            }
        }
        return httpContext;
    }

    private HttpResponseInterceptor createResponseInterceptor() {
        return new HttpResponseInterceptor(){
            private ResponseContentEncoding responseConentEncoding = new ResponseContentEncoding();

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                if (HttpServiceClient.this.gzipEncodingEnabled.get()) {
                    this.responseConentEncoding.process(response, context);
                }
            }
        };
    }

    private HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){
            private RequestAcceptEncoding requestAcceptEncoding = new RequestAcceptEncoding();

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (HttpServiceClient.this.gzipEncodingEnabled.get()) {
                    this.requestAcceptEncoding.process(request, context);
                }
            }
        };
    }

    private String preparePrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (!prefix.startsWith("/")) {
            prefix = "/" + prefix;
        }
        if (prefix.endsWith("/")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public String getHost() {
        return this.httpHost.getHostName();
    }

    public int getPort() {
        return this.httpHost.getPort();
    }

    public void setCredentials(String username, String password) {
        AuthScope authScope = new AuthScope(this.httpHost.getHostName(), this.httpHost.getPort());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        this.credentialsProvider.setCredentials(authScope, (Credentials)credentials);
    }

    public <T> T executeRequest(HttpRequestBase request, ResponseHandlerWrapper<T> responseHandlerWrapper) throws WebserviceException {
        return this.executeRequest(request, responseHandlerWrapper, (RequestFailedHandler)new IgnoreRequestFailedHandler(), false);
    }

    public <T> T executeRequest(HttpRequestBase request, ResponseHandler<T> responseHandler) throws WebserviceException {
        return this.executeRequest(request, responseHandler, (RequestFailedHandler)new IgnoreRequestFailedHandler(), false);
    }

    public <T> T executeRequest(HttpRequestBase request, ResponseHandler<T> responseHandler, RequestFailedHandler failedHandler) throws WebserviceException {
        return this.executeRequest(request, responseHandler, failedHandler, false);
    }

    public <T> Abortable executeRequestAsync(HttpRequestBase request, ResponseHandler<T> responseHandler) {
        return this.executeRequestAsync(request, responseHandler, new IgnoreRequestFailedHandler());
    }

    public <T> Abortable executeRequestAsync(final HttpRequestBase request, final ResponseHandler<T> responseHandler, final RequestFailedHandler failedHandler) {
        FutureTask requestTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws WebserviceException {
                try {
                    return HttpServiceClient.this.executeRequest(request, responseHandler, failedHandler, true);
                }
                catch (RequestAbortedException exc) {
                    throw exc;
                }
                catch (WebserviceException exc) {
                    throw exc;
                }
            }
        });
        this.executor.execute(requestTask);
        return new RequestAbortable(requestTask, request);
    }

    public void close() {
        logger.info("Closing open connections");
        this.executor.shutdownNow();
        Collection<HttpRequestBase> pendingRequests = this.pendingRequestCache.getPendingRequests();
        if (!pendingRequests.isEmpty()) {
            logger.debug("Aborting %d pending requests", pendingRequests.size());
            for (HttpRequestBase request : pendingRequests) {
                request.abort();
            }
        }
    }

    public void addRequestListener(RequestListener listener) {
        this.listeners.add(listener);
    }

    public void removeRequestListener(RequestListener listener) {
        this.listeners.remove(listener);
    }

    public void setGzipEncoding(boolean enabled) {
        this.gzipEncodingEnabled.set(enabled);
    }

    private <T> T executeRequest(HttpRequestBase request, ResponseHandler<T> responseHandler, RequestFailedHandler failedHandler, boolean asynchron) throws WebserviceException {
        try {
            return this.executeRequest(request, new ResponseHandlerWrapper<T>(responseHandler), failedHandler, asynchron);
        }
        catch (InitializationException exc) {
            throw new WebserviceException(exc);
        }
    }

    private <T> T executeRequest(HttpRequestBase request, ResponseHandlerWrapper<T> responseHandlerWrapper, RequestFailedHandler failedHandler, boolean asynchron) throws WebserviceException {
        logger.info("Executing request %s %s", request.getMethod(), request.getRequestLine().getUri());
        BasicHttpContext httpContext = this.createContext();
        request.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        if (this.pathPrefix != null) {
            request.setURI(URI.create(this.pathPrefix + request.getURI().toString()));
        }
        this.notifyRequestCreated(request);
        try {
            Object result = this.httpClient.execute(this.httpHost, (HttpRequest)request, responseHandlerWrapper, (HttpContext)httpContext);
            this.notifyRequestFinished(request);
            return (T)result;
        }
        catch (HttpHostConnectException exc) {
            WebserviceException connectException = new WebserviceException("Could not connect to %s service at %s:%d", this.httpHost.getSchemeName().toUpperCase(), this.httpHost.getHostName(), this.httpHost.getPort());
            this.notifyRequestFailed(request, asynchron, connectException);
            failedHandler.requestFailed(connectException);
            throw connectException;
        }
        catch (SSLPeerUnverifiedException exc) {
            WebserviceException certificateException = new WebserviceException("Could not verify server certificate for %s", this.httpHost.getHostName());
            this.notifyRequestFailed(request, asynchron, certificateException);
            failedHandler.requestFailed(certificateException);
            throw certificateException;
        }
        catch (ClientProtocolException exc) {
            httpContext.clear();
            if (exc.getCause() != null && exc.getCause() instanceof WebserviceException) {
                this.notifyRequestFailed(request, asynchron, exc.getCause());
                WebserviceException webserviceException = (WebserviceException)exc.getCause();
                failedHandler.requestFailed(webserviceException);
                throw webserviceException;
            }
            WebserviceException protocolException = new WebserviceException(exc);
            this.notifyRequestFailed(request, asynchron, protocolException);
            failedHandler.requestFailed(protocolException);
            throw protocolException;
        }
        catch (Exception exc) {
            if (request.isAborted()) {
                logger.info("Aborted request %s %s", request.getMethod(), request.getRequestLine().getUri());
                this.notifyRequestAborted(request);
                failedHandler.requestAborted();
                throw new RequestAbortedException();
            }
            logger.logExceptionIfDebugEnabled(exc);
            this.notifyRequestFailed(request, asynchron, exc);
            WebserviceException webserviceException = new WebserviceException(exc);
            failedHandler.requestFailed(webserviceException);
            throw webserviceException;
        }
    }

    private void notifyRequestCreated(HttpRequestBase request) {
        for (RequestListener listener : this.listeners) {
            listener.requestCreated(request);
        }
    }

    private void notifyRequestFinished(HttpRequestBase request) {
        for (RequestListener listener : this.listeners) {
            listener.requestFinished(request);
        }
    }

    private void notifyRequestFailed(HttpRequestBase request, boolean reportException, Throwable exc) {
        for (RequestListener listener : this.listeners) {
            if (reportException) {
                listener.requestFailed(request, exc);
                continue;
            }
            listener.requestFailed(request);
        }
    }

    private void notifyRequestAborted(HttpRequestBase request) {
        for (RequestListener listener : this.listeners) {
            listener.requestAborted(request);
        }
    }
}

